/* sqUnixAsynchFile.c -- non-blocking file i/o
 * 
 *   Copyright (C) 1996 1997 1998 1999 2000 2001 Ian Piumarta and individual
 *      authors/contributors listed elsewhere in this file.
 *   All rights reserved.
 *   
 *   This file is part of Unix Squeak.
 * 
 *   This file is distributed in the hope that it will be useful, but WITHOUT
 *   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *   FITNESS FOR A PARTICULAR PURPOSE.
 *   
 *   You may use and/or distribute this file ONLY as part of Squeak, under
 *   the terms of the Squeak License as described in `LICENSE' in the base of
 *   this distribution, subject to the following restrictions:
 * 
 *   1. The origin of this software must not be misrepresented; you must not
 *      claim that you wrote the original software.  If you use this software
 *      in a product, an acknowledgment to the original author(s) (and any
 *      other contributors mentioned herein) in the product documentation
 *      would be appreciated but is not required.
 * 
 *   2. This notice may not be removed or altered in any source distribution.
 * 
 *   Using or modifying this file for use in any context other than Squeak
 *   changes these copyright conditions.  Read the file `COPYING' in the base
 *   of the distribution before proceeding with any such use.
 * 
 *   You are STRONGLY DISCOURAGED from distributing a modified version of
 *   this file under its original name without permission.  If you must
 *   change it, rename it first.
 */

/* Author: Ian.Piumarta@INRIA.Fr
 *
 * Last edited: 2001-02-12 15:06:42 by piumarta on rnd10-51.rd.wdi.disney.com
*/

/*
  Experimental support for asynchronous file reading and writing.

  When a read or write operation is initiated, control is returned to Squeak
  immediately.  A semaphore is signaled when the operation completes, at which
  time the client can find out how many bytes were actually read or written
  and copy the results of the read operation from the file buffer into a Squeak
  buffer.  Only one operation may be in progress on a given file at a given time,
  but operations on different files may be done in parallel.

  The semaphore is signalled once for each transfer operation that is successfully
  started, even if that operation later fails.  Write operations always write
  their entire buffer if they succeed, but read operations may transfer less than
  their buffer size if they are started less than a buffer's size from the end
  of the file.
  
  The state of a file is kept in the following structure, which is stored directly
  in a Squeak ByteArray object:

    typedef struct {
	  int	sessionID;
	  void *state;		// private to the implementation
    } AsyncFile;

  The session ID is used to detect stale files--files that were open
  when the image was saved.  The state pointer of such files is meaningless.
  Async file handles use the same session ID as ordinary file handles.

  Note: These primitives are experimental!  They need not be implemented on
  every platform, and they may be withdrawn or replaced in a future release.
*/

#include "sq.h"
#include "AsynchFilePlugin.h"


/*** module initialisation ***/


int asyncFileInit(void)
{
  return 0;
}

int asyncFileShutdown(void)
{
  return 0;
}


/*** public functions ***/


int asyncFileOpen(AsyncFile *f, int fileNamePtr, int fileNameSize,
		  int writeFlag, int semaIndex)
{
  return 0;
}


int asyncFileClose(AsyncFile *f)
{
  return 0;
  
}


int asyncFileRecordSize(void)
{
  return 0;
}


int asyncFileReadResult(AsyncFile *f, int bufferPtr, int bufferSize)
{
  return 0;
}


int asyncFileReadStart(AsyncFile *f, int fPosition, int count)
{
  return 0;
}


int asyncFileWriteResult(AsyncFile *f)
{
  return 0;
}


int asyncFileWriteStart(AsyncFile *f, int fPosition, int bufferPtr, int bufferSize)
{
  return 0;
}


int ioCanOpenAsyncFileOfSizeWritable(char* fileNameIndex, int fileNameSize, int writeFlag)
{
  return true;
}
