/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlLogger
implements BuildListener {
    private static final DocumentBuilder builder = XmlLogger.getDocumentBuilder();
    private static final String BUILD_TAG = "build";
    private static final String TARGET_TAG = "target";
    private static final String TASK_TAG = "task";
    private static final String MESSAGE_TAG = "message";
    private static final String NAME_ATTR = "name";
    private static final String TIME_ATTR = "time";
    private static final String PRIORITY_ATTR = "priority";
    private static final String LOCATION_ATTR = "location";
    private static final String ERROR_ATTR = "error";
    private Document doc;
    private Element buildElement;
    private Element targetElement;
    private Element taskElement;
    private long buildStartTime;
    private long targetStartTime;
    private long taskStartTime;
    private Stack targetTimeStack = new Stack();
    private Stack targetStack = new Stack();
    private Stack taskTimeStack = new Stack();
    private Stack taskStack = new Stack();

    public void buildFinished(BuildEvent event) {
        long totalTime = System.currentTimeMillis() - this.buildStartTime;
        this.buildElement.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
        if (event.getException() != null) {
            this.buildElement.setAttribute(ERROR_ATTR, event.getException().toString());
        }
        try {
            String outFilename = event.getProject().getProperty("XmlLogger.file");
            if (outFilename == null) {
                outFilename = "log.xml";
            }
            FileWriter out = new FileWriter(outFilename);
            out.write("<?xml:stylesheet type=\"text/xsl\" href=\"log.xsl\"?>\n\n");
            XmlLogger.write(this.buildElement, out, 0);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException exc) {
            throw new BuildException("Unable to close log file", exc);
        }
        this.buildElement = null;
    }

    public void buildStarted(BuildEvent event) {
        this.buildStartTime = System.currentTimeMillis();
        this.doc = builder.newDocument();
        this.buildElement = this.doc.createElement(BUILD_TAG);
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public void messageLogged(BuildEvent event) {
        Element messageElement = this.doc.createElement(MESSAGE_TAG);
        String name = "debug";
        switch (event.getPriority()) {
            case 0: {
                name = ERROR_ATTR;
                break;
            }
            case 1: {
                name = "warn";
                break;
            }
            case 2: {
                name = "info";
                break;
            }
            default: {
                name = "debug";
            }
        }
        messageElement.setAttribute(PRIORITY_ATTR, name);
        Text messageText = this.doc.createTextNode(event.getMessage());
        messageElement.appendChild(messageText);
        if (this.taskElement != null) {
            this.taskElement.appendChild(messageElement);
        } else if (this.targetElement != null) {
            this.targetElement.appendChild(messageElement);
        } else {
            this.buildElement.appendChild(messageElement);
        }
    }

    public void targetFinished(BuildEvent event) {
        long totalTime = System.currentTimeMillis() - this.targetStartTime;
        this.targetElement.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
        if (this.taskElement == null) {
            this.buildElement.appendChild(this.targetElement);
        } else {
            this.taskElement.appendChild(this.targetElement);
        }
        this.targetElement = null;
        if (!this.targetStack.isEmpty()) {
            this.targetStartTime = (Long)this.targetTimeStack.pop();
            this.targetElement = (Element)this.targetStack.pop();
        }
    }

    public void targetStarted(BuildEvent event) {
        if (this.targetElement != null) {
            this.targetTimeStack.push(new Long(this.targetStartTime));
            this.targetStack.push(this.targetElement);
        }
        this.targetStartTime = System.currentTimeMillis();
        this.targetElement = this.doc.createElement(TARGET_TAG);
        this.targetElement.setAttribute(NAME_ATTR, event.getTarget().getName());
    }

    public void taskFinished(BuildEvent event) {
        long totalTime = System.currentTimeMillis() - this.taskStartTime;
        this.taskElement.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
        this.targetElement.appendChild(this.taskElement);
        this.taskElement = null;
        if (!this.taskStack.isEmpty()) {
            this.taskStartTime = (Long)this.taskTimeStack.pop();
            this.taskElement = (Element)this.taskStack.pop();
        }
    }

    public void taskStarted(BuildEvent event) {
        if (this.taskElement != null) {
            this.taskTimeStack.push(new Long(this.taskStartTime));
            this.taskStack.push(this.taskElement);
        }
        this.taskStartTime = System.currentTimeMillis();
        this.taskElement = this.doc.createElement(TASK_TAG);
        String name = event.getTask().getClass().getName();
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        this.taskElement.setAttribute(NAME_ATTR, name);
        this.taskElement.setAttribute(LOCATION_ATTR, event.getTask().getLocation().toString());
    }

    private static void write(Element element, Writer out, int indent) throws IOException {
        int i = 0;
        while (i < indent) {
            out.write("\t");
            ++i;
        }
        out.write("<");
        out.write(element.getTagName());
        NamedNodeMap attrs = element.getAttributes();
        int i2 = 0;
        while (i2 < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i2);
            out.write(" ");
            out.write(attr.getName());
            out.write("=\"");
            out.write(attr.getValue());
            out.write("\"");
            ++i2;
        }
        out.write(">");
        boolean hasChildren = false;
        NodeList children = element.getChildNodes();
        int i3 = 0;
        while (i3 < children.getLength()) {
            Node child = children.item(i3);
            if (child.getNodeType() == 1) {
                if (!hasChildren) {
                    out.write("\n");
                    hasChildren = true;
                }
                XmlLogger.write((Element)child, out, indent + 1);
            }
            if (child.getNodeType() == 3) {
                out.write(((Text)child).getData());
            }
            ++i3;
        }
        if (hasChildren) {
            int i4 = 0;
            while (i4 < indent) {
                out.write("\t");
                ++i4;
            }
        }
        out.write("</");
        out.write(element.getTagName());
        out.write(">\n");
    }
}

