<?php
// $Horde: horde/lib/MIME/Viewer/mspowerpoint.php,v 1.3.2.1 2001/12/23 20:19:07 chuck Exp $

/**
 * The MIME_Viewer_mspowerpoint class renders out Microsoft Powerpoint
 * documents in HTML format by using the xlHtml package.
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @version $Revision: 1.3.2.1 $
 * @since   Horde 1.3
 * @package horde.mime.viewer
 */
class MIME_Viewer_mspowerpoint extends MIME_Viewer {

    /**
     * Render out the currently set contents using ppthtml.
     * The $mime_part class variable has the information to render
     * out, encapsulated in a MIME_Part object.
     * @return string HTML pretty-print of the content
     */
    function render($params = null)
    {
        global $mime_drivers;

        $tmp_ppt = Horde::getTempFile('horde_mspowerpoint');

        $fh = fopen($tmp_ppt, 'w');
        fwrite($fh, $this->mime_part->getContents());
        fclose($fh);

        $data = '';
        $pipe = popen($mime_drivers['horde']['mspowerpoint']['location'] . " $tmp_ppt 2>&1", 'r');
        while (($rc = fgets($pipe, 8192))) {
            $data .= $rc;
        }

        pclose($pipe);
        unlink($tmp_ppt);

        return $data;
    }

    function getType()
    {
        return 'text/html';
    }

}
