<?php
// $Horde: horde/lib/MIME/Viewer/msexcel.php,v 1.4.2.2 2001/12/23 20:19:07 chuck Exp $

/**
 * The MIME_Viewer_msexcel class renders out Microsoft Excel
 * documents in HTML format by using the xlHtml package.
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @version $Revision: 1.4.2.2 $
 * @since   Horde 1.3
 * @package horde.mime.viewer
 */
class MIME_Viewer_msexcel extends MIME_Viewer {

    /**
     * Render out the currently set contents using xlhtml.
     * The $mime_part class variable has the information to render
     * out, encapsulated in a MIME_Part object.
     * @return string HTML pretty-print of the content
     */
    function render($params = null)
    {
        global $mime_drivers;

        $tmp_xls = Horde::getTempFile('horde_msexcel');

        $fh = fopen($tmp_xls, 'w');
        fwrite($fh, $this->mime_part->getContents());
        fclose($fh);

        $data = '';
        $pipe = popen($mime_drivers['horde']['msexcel']['location'] . " $tmp_xls 2>&1", 'r');
        while (($rc = fgets($pipe, 8192))) {
            $data .= $rc;
        }

        pclose($pipe);
        unlink($tmp_xls);

        /* Strip out the extraneous HTML from xlHtml, and output it.
         * TODO: figure out why this doesn't work with preg_replace! - avsm */
        $res_arr = preg_split('/\<\/?BODY.*\>/', $data);
        if (sizeof($res_arr) == 3) {
            return '<pre>' . $res_arr[1] . '</pre>';
        }
    }

    function getType()
    {
        return 'text/html';
    }

}
