<?php
/*
 * $Horde: horde/help.php,v 2.41.2.3 2002/01/02 17:05:06 jan Exp $
 *
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Help.php';

$title = _("Help");
$show = strtolower(Horde::getFormData('show', 'index'));
$module = strtolower(basename(Horde::getFormData('module', 'horde')));
$topic = Horde::getFormData('topic');

if (Auth::getAuth()) {
    $registry->pushApp($module);
    Lang::setLang($prefs->getValue('language'));
}

$help_dir = ($module == 'horde') ? './locale/' : "./$module/locale/";
$help_file = $help_dir . "$language/help.xml";

if ($show == 'index') {
    include $registry->getTemplatePath('horde') . '/help/index.inc';
} else {
    include $registry->getTemplatePath('horde') . '/common-header.inc';
    if ($show == 'menu') {
        include $registry->getTemplatePath('horde') . '/help/menu.inc';
    } else {
        include $registry->getTemplatePath('horde') . '/help/header.inc';

        $help = new Help(HELP_SOURCE_FILE, $help_file);
        if (($show == 'entry') && !empty($topic)) {
            $help->lookup($topic);
            $help->display();
        } else {
            $topics = $help->topics();
            foreach ($topics as $id => $title) {
                Horde::plink($registry->getWebRoot('horde') . "/help.php?show=entry&amp;module=$module&amp;topic=$id", '', 'helpitem');
                echo $title . "</a><br />\n";
            }
        }
        $help->cleanup();

        include $registry->getTemplatePath('horde') . '/help/footer.inc';
    }
}

require $registry->getTemplatePath('horde') . '/common-footer.inc';

?>
