#ifndef __LS_ICONBOXWIN_H__
#define __LS_ICONBOXWIN_H__

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-client.h>

#define LS_TYPE_ICONBOXWIN		(ls_iconboxwin_get_type())
#define LS_ICONBOXWIN(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), LS_TYPE_ICONBOXWIN, LSIconBoxWin))
#define LS_ICONBOXWIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), LS_TYPE_ICONBOXWIN, LSIconBoxWinClass))
#define LS_IS_ICONBOXWIN(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), LS_TYPE_ICONBOXWIN))
#define LS_IS_ICONBOXWIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), LS_TYPE_ICONBOXWIN))

typedef struct _LSIconBoxWinClass LSIconBoxWinClass;
typedef struct _LSIconBoxWinPrivate LSIconBoxWinPrivate;
typedef struct _LSIconBoxWin LSIconBoxWin;

#include <ls_iconbox.h>
#include <ls_icon.h>

struct _LSIconBoxWin 
{
  GtkWindow		parent_instance;
  LSIconBoxWinPrivate	*priv;
};

struct _LSIconBoxWinClass 
{
  GtkWindowClass	parent_class;
};

GType		ls_iconboxwin_get_type();
LSIconBoxWin	*ls_iconboxwin_new(NetkScreen *pScreen);
void		ls_iconboxwin_show(LSIconBoxWin *plsibw);
void		ls_iconboxwin_hide(LSIconBoxWin *plsibw);
void		ls_iconboxwin_set_orientation(LSIconBoxWin *plsibw, 
    		  glong lOrientation);
void		ls_iconboxwin_create_menu(LSIconBoxWin *plsib);
void 		ls_iconboxwin_set_offset(LSIconBoxWin *plsib, gint nX, gint nY);
void 		ls_iconboxwin_get_offset(LSIconBoxWin *plsib, gint *nX, gint *nY);
glong		ls_iconboxwin_get_horizontal_position(LSIconBoxWin *pslib);
glong		ls_iconboxwin_get_vertical_position(LSIconBoxWin *pslib);
void		ls_iconboxwin_set_horizontal_position(LSIconBoxWin *pslib, glong lAlign);
void		ls_iconboxwin_set_vertical_position(LSIconBoxWin *pslib, glong lAlign);
LSIconBox 	*ls_iconboxwin_get_iconbox(LSIconBoxWin *plsibw);
void		ls_iconboxwin_set_hide_on_empty(LSIconBoxWin *plsibw, 
    		  gboolean bHide);
#endif					/* ifndef __LS_ICONBOXWIN_H__		*/
