/***************************************************************************
                           kmmanagerlistview.h -
                         ---------------------------
    begin                : Tue Mar  6 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.5 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMMANAGERLISTVIEW_H
#define KMMANAGERLISTVIEW_H

#include <klistview.h>
#include <kaction.h>
#include <kconfig.h>
#include "kcontainerview.h"
#include "ktmanager.h"

class KMagoView;
class KMManagerListItem;
class KMManagerListDrag;

/**
 * @short ListView to display @ref KMManager contents.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kmmanagerlistview.h,v 1.5 2001/04/08 09:43:49 sergio Exp $
 */

class KMManagerListView : public KListView, public KContainerView
{
   Q_OBJECT

public:
   KMManagerListView(KMManager m, KMagoDoc *doc, Callback cb, QWidget *parent,
		     const char *name = 0);
   virtual ~KMManagerListView();

   virtual const char * name() const { return KListView::name(); }

   //virtual QSize sizeHint() const { return QSize(200, 100); }
   virtual QSize minimumSizeHint() const { return QSize(0, 0); }
   virtual void setOrientation(bool vert);

   KMManagerListItem * itemFind(KObject item) const;
   virtual void itemAdd(KObject item);
   virtual void itemRemove(KObject item);
   virtual void itemSelect(KObject item);
   virtual void itemUpdate(KObject item);
   virtual void itemUpdateText(KObject item);
   virtual KObject itemFirst() const;
   virtual KObject itemAbove(KObject item) const;
   virtual KObject itemBelow(KObject item) const;
   virtual void clear() { KListView::clear(); }
   virtual void initView();
   virtual void applySettings(KConfig *);
   virtual void saveSettings(KConfig *);
   virtual void setSortBy(ModIndex p, bool increasing = true);
   virtual ModIndex sortBy() const { return _sortBy; }
   int column(int i) const;
   virtual bool sortDir() const { return _sortDir; }

protected:
   void initActions();
   virtual void setSorting (int column, bool increasing = true);
   virtual QDragObject* dragObject() const;
   virtual bool acceptDrag(QDropEvent *event) const;
   void contentsDragMoveEvent(QDragMoveEvent *event);
   //void contentsDropEvent(QDropEvent *event);

protected slots:
   void slotDropped(QDropEvent * event, QListViewItem *parent,
		    QListViewItem *after );
   void slotExecuted(QListViewItem *item);
   void slotContextMenu(KListView*, QListViewItem *i, const QPoint &p);
   void slotSelectionChanged(QListViewItem *i);
   void slotItemRenamed(QListViewItem * item, const QString &name, int col);
   void slotInitView();

signals:
   void sigSelectionChanged(KObject item);

private:
   KToggleAction *_viewTitle,
      *_viewCnt,
      *_viewActCnt,
      *_viewPriority,
      *_viewBand,
      *_viewMBand,
      *_viewID;
   ModIndex _sortBy;
   int _sortByCol;
   bool _sortDir;
   ModIndex _sortIdx[2];
   int _columnMap[14];
};


/**
 * @short ListView Item to display @ref KTManager.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kmmanagerlistview.h,v 1.5 2001/04/08 09:43:49 sergio Exp $
 */

class KMManagerListItem : public QListViewItem
{
public:
   KMManagerListItem(QListView *parent, KTManager mngr);
   virtual ~KMManagerListItem() {}
   KTManager manager() const { return m; }
   virtual QString text(int column) const;
   virtual QString key(int column, bool ascending) const;
   void update();
   virtual bool acceptDrop ( const QMimeSource * mime ) const;

private:
   KTManager m;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
