/***************************************************************************
                          kdropper.h  -  description
                             -------------------
    begin                : Tue Jan 2 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDROPPER_H
#define KDROPPER_H

#include <qwidget.h>
#include <qlabel.h>

class KMagoDoc;

/**
 * @short drop target window for d'n'd with netscape
 *
 * @author Sergio Moretti
 *
 * @version $Id: kdropper.h,v 1.2 2001/03/23 17:14:59 sergio Exp $
 */

class KDropper : public QLabel
{
   Q_OBJECT
public: 
   KDropper(KMagoDoc *doc, QWidget *parent=0, const char *name=0);
   ~KDropper();

   KMagoDoc * doc() const;

protected:
   void dropEvent(QDropEvent *event);
   void closeEvent(QCloseEvent * e);
   void dragEnterEvent(QDragEnterEvent *event);

   signals:
   void sigClose();

private:
   KMagoDoc *_doc;
};

#endif
