/*
 * Copyright (c) 1995, 1996, 1997, 2000, 2001, Mark Buser.
 * Copyright (c) 2001, 2002, 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/xinvest.h,v 2.17 2004/03/13 21:20:04 danny Exp $
 */
#ifndef	__XINVEST_H_
#define	__XINVEST_H_

#include <X11/Intrinsic.h>
#include <X11/extensions/Print.h>
#include "color.h"

/* Globals */
extern char version[];

Widget Filemenu; 
Widget Editmenu; 
Widget Optionmenu; 
Widget Accountmenu; 
Widget Transtext; 
Widget Translabel;
Widget Filecwdlabel;
Widget Listfile;
Widget Timesform;
Widget Timelform;
Widget Valrow;
Widget Graphhbar; 
Widget Graphhline; 
Widget GraphconstToggle; 
Widget Graphscale; 
Widget Graphcform;  
Widget Portpbut;
Widget Portmbut;
Widget Portcbut;
Widget Portabut;
Widget Portpercentlist;
Widget Portoptmenu;
Widget Portvaluelabel; 
Widget Calclabel;
Widget Calclabels[5];
Widget Calctext[3]; 
Widget Savebut;
Widget Nextbut; 
Widget Prevbut; 
Widget Gainbut; 
Widget Graphbut;
Widget Portbut;
Widget Editbut;
Widget Toolmenu, Infoframe, Graphform, Reportform, Portform, Calcform;

/* 
** Forward Declarations 
*/

/* Portfolio callbacks */
extern void  portAddSubList();
extern void  portTraverse();

/* Calculator callbacks */
extern void  calcFuncSel();
extern void  calcTextSel();
extern void  calcCompSel();

struct report_attrib {
	Display		*dpy;
	XFontStruct	*font, *sfont;
	GC		gc;
	Pixmap		pix;
	int		x, y;
	Pixel		fg, bg, shad, hilite, tshad;
	int		shadThick;
	int		avgWidth;
} report_attrib;

/* Application resources */
typedef struct {
  XmFontList graph_font_list;
  XmFontList print_font_list;
  Boolean    install;
  Boolean    help;
  String     color0, color1, color2, color3, color4, color5,
             color6, color7, colorRed, colorGreen, colorGrey,
             colorWhite, colorBlack, colorPrintBackground,
             colorPrintForeground, colorPrintIllustrations;
  Pixel      _color0, _color1, _color2, _color3, _color4, _color5,
             _color6, _color7, _colorRed, _colorGreen, _colorGrey,
             _colorWhite, _colorBlack, _colorPrintBackground,
             _colorPrintForeground, _colorPrintIllustrations;
  char       *restore;
  int		maxaccounts;
}  AppData;

#define	QF_LINE_LEN	256
#endif
