/*
 * Copyright (c) 1997, 1999, 2000, Mark Buser.
 * Copyright (c) 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/session.c,v 1.23 2004/04/30 16:00:18 danny Exp $
 */

static const char id[] = "$Header: /pack/anoncvs/xinvest/src/session.c,v 1.23 2004/04/30 16:00:18 danny Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <Xm/Xm.h>
#include <Xm/Protocols.h>
#if XtSpecificationRelease > 5
#include <X11/SM/SMlib.h>
#endif

#include "session.h"
#include "status.h"

#ifndef XQUOTE
#include "fileXi.h"
#endif

extern XrmOptionDescRec *kill_options;

char *sessSaveFile (Boolean manual)
{
  char *savepathname;
  char *savefilename;
#ifdef XQUOTE
  char sessfilename[] = "xqteXXXXXX";
  char manfilename[] = ".xquoterc";
#else
  char sessfilename[] = "xinvXXXXXX";
  char manfilename[] = ".xinvestrc";
#endif
  char *fullpathname;

  /*
  ** Determine session save area and filename.
  */
  if ( (savepathname = getenv ("SM_SAVE_DIR")) == NULL)
    savepathname = getenv ("HOME");

  if (manual) {
    savefilename = manfilename;
    fullpathname = XtMalloc (strlen(savepathname) + strlen(savefilename) +2);
    if (fullpathname == NULL) {
      write_status ("Could not allocate memory for path.\n", ERR);
      return (NULL);
    }
    sprintf (fullpathname, "%s/%s", savepathname, savefilename);

  } else {
    savefilename = sessfilename;

#ifdef	HAVE_MKSTEMP
    fullpathname = XtMalloc (strlen(savepathname) + strlen(savefilename) +2);
    if (fullpathname == NULL) {
      write_status ("Could not allocate memory for path.\n", ERR);
      return (NULL);
    }
    sprintf (fullpathname, "%s/%s", savepathname, savefilename);
    close(mkstemp(fullpathname));
#else
# ifndef X_NOT_POSIX
    fullpathname = XtMalloc (strlen(savepathname) + strlen(savefilename) +2);
    if (fullpathname == NULL) {
      write_status ("Could not allocate memory for path.\n", ERR);
      return (NULL);
    }
    sprintf (fullpathname, "%s/%s", savepathname, savefilename);
    fullpathname = mktemp (fullpathname);
# else
    fullpathname = tempnam (savepathname, "xqte");
# endif
#endif
  }

  return (fullpathname);
}

#if !defined(CDE) && XtSpecificationRelease > 5

/* ARGSUSED */
void sessSave ( Widget shell, XtPointer client_data, XtPointer call_data)
{
  XtCheckpointToken token = (XtCheckpointToken) call_data;
  String saveFile = sessSaveFile(False);

  char **argv;
  int  argc;

  String *discard = (String *)NULL;
  String *restart = (String *)NULL;
  int i;

  if (token->shutdown || token->interact_style != SmInteractStyleNone)
    XtSetSensitive ( shell, False);

  if ( (token->save_success = saveState(saveFile)) ) {
    /* 
    ** Update restore command 
    */

    XtVaGetValues ( shell, XtNrestartCommand, &argv, NULL);
    argc = 0;     /* How many arguments */
    if (argv) {
      XrmDatabase database = (XrmDatabase) NULL;

      while ( argv[argc++] )
        ;
      if (argc) argc--;       /* don't count NULL last arg */

      /* Remove arguments we don't want to save */
#ifdef XQUOTE
      XrmParseCommand ( &database, kill_options, XtNumber(kill_options),
                        "Xquote", &argc, argv );
#else
      XrmParseCommand ( &database, kill_options, XtNumber(kill_options),
                        "Xinvest", &argc, argv );
#endif
      XrmDestroyDatabase (database);

      restart = (char **) XtMalloc ((argc+3) * sizeof(String));
      if (restart) {
        for (i=0; i < argc; i++)
          restart[i] = XtNewString ( argv[i] );
        restart[argc++] = XtNewString("-restore");
        restart[argc++] = XtNewString(saveFile);
        restart[argc]   = NULL;
  
        XtVaSetValues ( shell, XtNrestartCommand, restart, NULL);
      }
    }

    /* 
    ** Update discard command 
    */
    i = 0;
    discard = (String *) XtMalloc ( 2 * sizeof(String) );
    if (discard) {
      discard[i] = XtMalloc ( strlen(saveFile) + strlen ("rm ") +1 );
      if (discard[i])
        sprintf ( discard[i++], "rm %s", saveFile );
      discard[i] = NULL;

      XtVaSetValues ( shell, XtNdiscardCommand, discard, NULL);
    }
  }

  XtFree (saveFile);
}
#else

/* ARGSUSED */
void sessSave ( Widget shell, XtPointer client_data, XtPointer call_data)
{
  char *saveFile = sessSaveFile(False);

  char **argv;
  int argc;
  char restore[] = "-restore";

  XGetCommand ( XtDisplay (shell), XtWindow (shell), &argv, &argc );

  if ( saveState (saveFile) ) {
    XrmDatabase database = (XrmDatabase) NULL;

    /* Remove arguments we don't want to save (-restore) */
#ifdef XQUOTE
    XrmParseCommand ( &database, kill_options, XtNumber(kill_options),
                      "Xquote", &argc, argv );
#else
    XrmParseCommand ( &database, kill_options, XtNumber(kill_options),
                      "Xinvest", &argc, argv );
#endif
    XrmDestroyDatabase (database);

    /* Add new -restore to read state file */
    argv = (char **) XtRealloc ( (char *)argv, (argc+2) * sizeof(char *));
    argv[argc++] = restore;
    argv[argc++] = saveFile;
    XSetCommand ( XtDisplay (shell), XtWindow (shell), argv, argc );

  } else
    XSetCommand ( XtDisplay (shell), XtWindow (shell), argv, argc );

  XtFree (saveFile);
  XFreeStringList ( argv );
}
#endif

/* ARGSUSED */
void sessResume ( Widget shell, XtPointer client_data, XtPointer call_data)
{
  XtSetSensitive ( shell, True);
}

#ifndef XQUOTE
/* ARGSUSED */
void sessDie ( Widget shell, XtPointer client_data, XtPointer call_data)
{
  XtDestroyApplicationContext (XtWidgetToApplicationContext(shell));
  exit(0);
}

void deleteWindow(Widget w, XtPointer client, XtPointer call)
{
	/*
	 * New code to save stuff that came in through live update
	 */
	SaveLiveData();

	sessDie(w, client, call);
}
#endif
