/*
 * Copyright (c) 1998, 1999, 2000, Mark Buser.
 * Copyright (c) 2001, 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/pref.c,v 2.13 2004/03/13 19:02:03 danny Exp $
 */
#include <stdlib.h>

#include <Xm/XmAll.h>

#include "account.h"
#include "askuser.h"
#include "portfolio.h"
#include "pref.h"
#include "xutil.h"

#ifndef	XQUOTE
#ifndef	QUOTE_FILTER
#define	XINVEST
#endif
#endif

#ifdef	XINVEST
#include "xinvest.h"
#endif

/*
** Local Globals for Preferences
*/

static int  optLocCurr;
static char *charLocCurr;
static int  useExch;
Widget	PrefLiveUpdateTF = NULL;
int	PrefLiveUpdateInterval = -1;
Boolean	PrefLiveUpdateSet = False;
Widget	PrefLiveUpdateToggle = NULL;

#ifdef	XINVEST
/* Initialized in prefInitState() */
static int  useBack;
static char *extBack;
static int  optLocDate;
static int  loptLocDate = 0;    /* set from opt menu callbacks */
static int  loptLocCurr = 0;    /* set from opt menu callbacks */
static int  prec;
static int  lprec = 2;          /* set from opt menu callbacks */

static Widget optBack = (Widget) NULL;
static Widget optBackExt = (Widget) NULL;
static Widget optDate = (Widget) NULL;
static Widget optCurr = (Widget) NULL;
static Widget optCurrChar = (Widget) NULL;
static Widget optCurrExch = (Widget) NULL;
static Widget optPrec = (Widget) NULL;

static void prefLiveUpdateToggle(Widget w, XtPointer client, XtPointer call);

/*
** Initialize preferences from resources
*/
void prefInitState(char *appname)
{
  XrmDatabase   db = XtScreenDatabase(XtScreenOfObject(per->Toplevel));
  XrmQuark      class[7], name[7];
  XrmValue      value;
  XrmRepresentation type;

  class[0] = XrmStringToQuark("Xinvest");
  class[1] = XrmStringToQuark("XmFrame");
  class[2] = XrmStringToQuark("XmForm");
  class[5] = NULLQUARK;

  name[0] = XrmStringToQuark(appname);
  name[1] = XrmStringToQuark("PrefBack");
  name[2] = XrmStringToQuark("form_0");
  name[5] = NULLQUARK;

  /* useBack */
  class[3] = XrmStringToQuark("XmToggleButton");
  class[4] = XrmStringToQuark("set");
  name[3] = XrmStringToQuark("button_0");
  name[4] = XrmStringToQuark("set");
  useBack = False;
  if (XrmQGetResource (db, name, class, &type, &value))
    if (strcmp(value.addr,"XmSET") == 0 || strcmp(value.addr,"True") == 0)
      useBack = True;

  /* extBack */
  class[3] = XrmStringToQuark("XmTextField");
  class[4] = XrmStringToQuark("value");
  name[3] = XrmStringToQuark("text_0");
  name[4] = XrmStringToQuark("value");
  if (XrmQGetResource (db, name, class, &type, &value))
    extBack = XtNewString (value.addr);
  else
    extBack = XtNewString ("bak");       /* default if no default */

  /* optLocDate */
  class[3] = XrmStringToQuark("XmMenuShell");
  class[4] = XrmStringToQuark("XmRowColumn");
  class[5] = XrmStringToQuark("menuHistory");
  class[6] = NULLQUARK;
  name[2] = XrmStringToQuark("form_1");
  name[3] = XrmStringToQuark("popup_PrefDateOpt");
  name[4] = XrmStringToQuark("PrefDateOpt");
  name[5] = XrmStringToQuark("menuHistory");
  name[6] = NULLQUARK;
  optLocDate = 0;
  if (XrmQGetResource (db, name, class, &type, &value))
    optLocDate = atoi (value.addr);

  /* optLocCurr */
  name[2] = XrmStringToQuark("form_2");
  name[3] = XrmStringToQuark("popup_PrefCurrOpt");
  name[4] = XrmStringToQuark("PrefCurrOpt");
  optLocCurr = 0;
  if (XrmQGetResource (db, name, class, &type, &value))
    optLocCurr = atoi (value.addr);
  
  /* charLocCurr */
  class[3] = XrmStringToQuark("XmTextField");
  class[4] = XrmStringToQuark("value");
  class[5] = NULLQUARK;
  name[1] = XrmStringToQuark("PrefCurr");
  name[2] = XrmStringToQuark("form_2");
  name[3] = XrmStringToQuark("text_0");
  name[4] = XrmStringToQuark("value");
  name[5] = NULLQUARK;
  if (XrmQGetResource (db, name, class, &type, &value))
    charLocCurr = XtNewString (value.addr);
  else
    charLocCurr = XtNewString ("$");     /* default if no default */

  /* useExch */
  class[3] = XrmStringToQuark("XmToggleButton");
  class[4] = XrmStringToQuark("set");
  name[3] = XrmStringToQuark("button_0");
  name[4] = XrmStringToQuark("set");
  useExch = False;
  if (XrmQGetResource (db, name, class, &type, &value))
    if (strcmp(value.addr,"XmSET") == 0 || strcmp(value.addr,"True") == 0)
      useExch = True;

  /* prec */
  class[3] = XrmStringToQuark("XmMenuShell");
  class[4] = XrmStringToQuark("XmRowColumn");
  class[5] = XrmStringToQuark("menuHistory");
  class[6] = NULLQUARK;
  name[2] = XrmStringToQuark("form_2");
  name[3] = XrmStringToQuark("popup_PrefPrecOpt");
  name[4] = XrmStringToQuark("PrefPrecOpt");
  name[5] = XrmStringToQuark("menuHistory");
  name[6] = NULLQUARK;
  prec = 2;
  if (XrmQGetResource (db, name, class, &type, &value))
    prec = atoi(value.addr);

}

/*
** Handle backup toggle button
*/
/* ARGSUSED */
void prefBackToggle ( Widget w, XtPointer client_data, XtPointer call_data)
{
  XmToggleButtonCallbackStruct *state =
         (XmToggleButtonCallbackStruct *) call_data;
  XtSetSensitive (optBackExt, (state->set==XmSET)?True:False);
}

/*
** Handle option menus 
*/
static void prefDateOpt (Widget w, XtPointer which, XtPointer call_data)
{
  loptLocDate = (int) which;
}

static void prefCurrOpt (Widget w, XtPointer which, XtPointer call_data)
{
  loptLocCurr = (int) which;
  /* Hide currency char if we're localized */
  XtSetSensitive (optCurrChar, (loptLocCurr!=PREF_CURR_LOC)?True:False);
}

static void prefPrecOpt (Widget w, XtPointer which, XtPointer call_data)
{
  lprec = (int) which;
}

/*
** Handle dialog ok,cancel buttons 
*/
static void prefProc (Widget w, XtPointer which, XtPointer call_data)
{
	char	*p;

  switch ((int) which) {

    case 0: /* Ok */
            XtPopdown (GetTopShell(w));

            /* Save new values */

            /* Backups on/off */
            if (XmToggleButtonGetState (optBack) == True)
              useBack = True;
            else
              useBack = False;
            /* Backup file extension */
            {
              char *backExt;
              backExt = XmTextFieldGetString (optBackExt);
              if (extBack)
                XtFree (extBack);
              extBack = XtNewString(backExt);
            }
            /* Date option menu - set in own handler */
            optLocDate = loptLocDate;
            /* Currency option menu - set in own handler */
            optLocCurr = loptLocCurr;
            /* Currency character */
            {
              char *curr;
              curr = XmTextFieldGetString (optCurrChar);
              if (strlen(curr)) {
                XtFree (charLocCurr);
                charLocCurr = XtNewString(curr);
              }
            }

	    /* Use exchange rate */

	    /* If it's changed we may need to update the portfolio tool */
            if (XmToggleButtonGetState (optCurrExch) != useExch) {
	      int num = accountsStatus (ACCOUNT_IN_PORTFOLIO);
	      int *j = (int *)XtCalloc (num, sizeof(int));
              if (num) {
		char prompt[] = "Exchange rate preference change, "
			        "update portfolio?"; 
		if (AskUser(per->Toplevel, prompt, "OK", "Cancel", YES) == YES) {
		  int i;
		  /* Remove from portfolio */
		  for (i=1; i <= numAccounts(); i++) {
                    if (accountStatus (i, ACCOUNT_IN_PORTFOLIO)) {
		      portAccount (i, PORT_DELETE);
		      *j++ = i;
		    }
		  }
		} else { /* User said no update, they know best */
		  num = 0;
		}
	      }

              useExch = (useExch==True)?False:True;

	      /* Re-add to portfolio */
	      while (num--) {
		portAccount (*--j, PORT_ADD);
	      }
	      XtFree ((char *)j);
            }

	    /* Live update */
	    p = XmTextFieldGetString(PrefLiveUpdateTF);
	    if (p) {
		    sscanf(p, "%d", &PrefLiveUpdateInterval);
		    XtFree(p);
	    }
	    PrefLiveUpdateSet = XmToggleButtonGadgetGetState(PrefLiveUpdateToggle);

            /* Precision - set in own handler */
            prec = lprec;
            break;

    case 1: /* Cancel */
            XtPopdown (GetTopShell(w));

            /* Restore previous values */
            XmToggleButtonSetState (optBack, (useBack)?True:False,False);
            XmTextFieldSetString (optBackExt, extBack);
            setOptionMenu (optDate, optLocDate);
            setOptionMenu (optCurr, optLocCurr);
            XmTextFieldSetString (optCurrChar, charLocCurr);
            XmToggleButtonSetState (optCurrExch, (useExch)?True:False,False);
            setOptionMenu (optPrec, prec);
            break;

    default: break;
  }
}


/*
** Access Routines (Session Management)
*/

/* Set backup account file extension */
void prefSetBack (int use, char *ext)
{
  if (use)
    useBack = True;
  else
    useBack = False;
  
  if (ext) {
    if (extBack)
      XtFree (extBack);
    extBack = XtNewString(ext);
  }
}

int prefGetBack (char **ext)
{
  if (ext)
   *ext = extBack;
  return (useBack);
}


/* Set preferred date format */
void prefSetDate (int which)
{
  if (which >= PREF_DATE_LOC && which <= PREF_DATE_DMY)
    optLocDate = which;
}

int prefGetDate ()
{
  return (optLocDate);
}
#endif	/* XINVEST */

/* Set preferred currency format */
void prefSetCurr (int which)
{
  if (which >= PREF_CURR_CD && which <= PREF_CURR_DC)
    optLocCurr = which;
}

int prefGetCurr ()
{
  return (optLocCurr);
}

void prefSetCurrChar (char *curr)
{
  if (charLocCurr) {
    XtFree (charLocCurr);
    charLocCurr = NULL;
  }
  if (curr)
    charLocCurr = XtNewString(curr);
}

char *prefGetCurrChar ()
{
  return (charLocCurr);
}

void prefSetUseCurr (int use)
{
  if (use)
    useExch = True;
  else
    useExch = False;
}

int prefGetUseCurr ()
{
  return (useExch);
}

#ifdef	XINVEST
/* Set arithmentic precision */
void prefSetPrec (int which)
{
  if (which >= 0 && which <= 6)
    prec = which;
}

int prefGetPrec ()
{
  return (prec);
}


/* Create preference dialog */
static Widget prefCreatePreference()
{
  char *frames[] =  {"PrefBack", "PrefDate", "PrefCurr", "PrefPrec", "PrefLiveUpdate"};
  char *forms[] =   {"form_0", "form_1", "form_2", "form_3", "form_4"};
  char *buttons[] = {"button_0", "button_1"};


  Widget dialog, form, pane, row, frame, button, label;
  int num;

  Dimension width, height, border;

  dialog = XtVaCreatePopupShell ("PrefPref", xmDialogShellWidgetClass,
                                 per->Toplevel, NULL);

  pane = XtVaCreateWidget ("PrefPane", xmPanedWindowWidgetClass,
                           dialog,
                           XmNsashWidth, 1,
                           XmNsashHeight, 1,
                           NULL);

  row = XtVaCreateWidget ("PrefRow", xmRowColumnWidgetClass, pane,
                          XmNnavigationType, XmNONE,
                          XmNtopAttachment, XmATTACH_FORM,
                          XmNleftAttachment, XmATTACH_FORM,
                          NULL);

  for (num = 0; num < XtNumber(frames); num ++) {

     frame =   XtVaCreateManagedWidget (frames[num],
                          xmFrameWidgetClass, row,
                          NULL);
     XtVaCreateManagedWidget (frames[num],
                          xmLabelGadgetClass, frame,
                          XmNchildType, XmFRAME_TITLE_CHILD,
                          XmNchildVerticalAlignment, XmALIGNMENT_CENTER,
                          NULL);
     form = XtVaCreateWidget (forms[num],
                          xmFormWidgetClass, frame,
                          NULL);

     switch (num) {

        case 0: 
                optBack = XtVaCreateManagedWidget ("button_0",
                            xmToggleButtonWidgetClass, form,
                            XmNset, (useBack == True),
                            XmNtopAttachment, XmATTACH_FORM,
                            XmNleftAttachment, XmATTACH_FORM,
                            XmNbottomAttachment, XmATTACH_FORM,
                            NULL);
                XtAddCallback ( optBack, XmNvalueChangedCallback,
                            (XtCallbackProc)prefBackToggle, (XtPointer)NULL );

                label = XtVaCreateManagedWidget ("label_0",
                            xmLabelGadgetClass, form,
                            XmNtopAttachment, XmATTACH_FORM,
                            XmNleftAttachment, XmATTACH_WIDGET,
                            XmNleftWidget, optBack,
                            XmNbottomAttachment, XmATTACH_FORM,
                            NULL);
                optBackExt = XtVaCreateManagedWidget ("text_0",
                            xmTextFieldWidgetClass, form,
                            XmNtopAttachment, XmATTACH_FORM,
                            XmNleftAttachment, XmATTACH_WIDGET,
                            XmNleftWidget, label,
                            XmNbottomAttachment, XmATTACH_FORM,
                            NULL);
                if (extBack)
                  XmTextFieldSetString (optBackExt, extBack);
                XtSetSensitive (optBackExt, useBack);
                break;

        case 1: 
                optDate = XmVaCreateSimpleOptionMenu (
                           form,"PrefDateOpt", NULL, (KeySym)NULL ,
                           optLocDate, (XtCallbackProc) prefDateOpt,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmNtopAttachment,  XmATTACH_FORM,
                           XmNleftAttachment, XmATTACH_FORM,
                  NULL);
                XtManageChild (optDate);
                break;

        case 2: 
                optCurr = XmVaCreateSimpleOptionMenu (
                           form,"PrefCurrOpt", NULL, (KeySym)NULL ,
                           optLocCurr, (XtCallbackProc) prefCurrOpt,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmNtopAttachment,  XmATTACH_FORM,
                           XmNleftAttachment, XmATTACH_FORM,
                     NULL);
                XtManageChild (optCurr);
                label = XtVaCreateManagedWidget ("label_0",
                            xmLabelGadgetClass, form,
                            XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
                            XmNtopWidget, optCurr,
                            XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
                            XmNbottomWidget, optCurr,
                            XmNleftAttachment, XmATTACH_WIDGET,
                            XmNleftWidget, optCurr,
                            NULL);
                optCurrChar = XtVaCreateManagedWidget ("text_0",
                            xmTextFieldWidgetClass, form,
                            XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
                            XmNtopWidget, label,
                            XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
                            XmNbottomWidget, label,
                            XmNleftAttachment, XmATTACH_WIDGET,
                            XmNleftWidget, label,
                            NULL);
                if (charLocCurr)
                  XmTextFieldSetString (optCurrChar, charLocCurr);
                /* Hide currency char if we're localized */
                XtSetSensitive (optCurrChar, (optLocCurr>0)?True:False);

		optCurrExch = XtVaCreateManagedWidget ("button_0",
                            xmToggleButtonWidgetClass, form,
                            XmNset, (useExch == True),
                            XmNtopAttachment, XmATTACH_WIDGET,
                            XmNtopWidget, optCurrChar,
                            XmNleftAttachment, XmATTACH_FORM,
                            XmNbottomAttachment, XmATTACH_FORM,
                            NULL);
                break;

        case 3: 
                optPrec = XmVaCreateSimpleOptionMenu (
                           form,"PrefPrecOpt", NULL, (KeySym)NULL,
                           prec, (XtCallbackProc) prefPrecOpt,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmVaPUSHBUTTON, NULL, NULL, NULL, NULL,
                           XmNtopAttachment,  XmATTACH_FORM,
                           XmNleftAttachment, XmATTACH_FORM,
                     NULL);
                XtManageChild (optPrec);
                break;

	case 4:	/* Live Update Preferences */
		{ Widget w;
			char	s[8];
		PrefLiveUpdateToggle = XtVaCreateManagedWidget("liveUpdateToggle",
			xmToggleButtonGadgetClass, form,
				XmNleftAttachment,	XmATTACH_FORM,
				XmNrightAttachment,	XmATTACH_NONE,
				XmNtopAttachment,	XmATTACH_FORM,
				XmNbottomAttachment,	XmATTACH_NONE,
			NULL);
		XtAddCallback(PrefLiveUpdateToggle, XmNvalueChangedCallback,
			prefLiveUpdateToggle, NULL);

		w = XtVaCreateManagedWidget("liveUpdateLabel",
			xmLabelGadgetClass, form,
				XmNleftAttachment,	XmATTACH_FORM,
				XmNleftOffset,		5,
				XmNrightAttachment,	XmATTACH_NONE,
				XmNtopAttachment,	XmATTACH_WIDGET,
				XmNtopWidget,		PrefLiveUpdateToggle,
				XmNtopOffset,		5,
				XmNbottomAttachment,	XmATTACH_FORM,
			NULL);
                PrefLiveUpdateTF = XtVaCreateManagedWidget ("text_0",
                            xmTextFieldWidgetClass, form,
				XmNleftAttachment,	XmATTACH_WIDGET,
				XmNleftWidget,		w,
				XmNleftOffset,		5,
				XmNrightAttachment,	XmATTACH_NONE,
				XmNtopAttachment,	XmATTACH_WIDGET,
				XmNtopWidget,		PrefLiveUpdateToggle,
				XmNtopOffset,		5,
				XmNbottomAttachment,	XmATTACH_FORM,
			NULL);

		/* Initialize */
		XtSetSensitive(PrefLiveUpdateTF, PrefLiveUpdateSet);
		sprintf(s, "%d", PrefLiveUpdateInterval);
		XmTextFieldSetString(PrefLiveUpdateTF, s);
		XmToggleButtonSetState(PrefLiveUpdateToggle, PrefLiveUpdateSet, False);
		}
		break;

     }
     XtManageChild (form);

  }

  XtManageChild (row);

  /* Buttons to add delete cancel exit */
  form = XtVaCreateWidget ( "ButForm", xmFormWidgetClass, pane,
                            XmNfractionBase, 5,
                            NULL );

  for (num=0; num < XtNumber(buttons); num++) {
    button = XtVaCreateManagedWidget ( buttons[num],
                                       xmPushButtonWidgetClass, form,
                                       XmNtopAttachment, XmATTACH_FORM,
                                       XmNbottomAttachment, XmATTACH_FORM,
                                       XmNleftAttachment, XmATTACH_POSITION,
                                       XmNleftPosition, 2*num+1,
                                       XmNrightAttachment, XmATTACH_POSITION,
                                       XmNrightPosition, 2*num+2,
                                       XmNshowAsDefault, (num==0)?True:False,
                                       XmNdefaultButtonShadowThickness, 1,
                                       NULL );
    XtAddCallback ( button, XmNactivateCallback,
                            (XtCallbackProc) prefProc, (XtPointer)num );
  }
  XtManageChild (form);
  XtManageChild (pane);

  /* Prevent pane from changing size */
  XtVaGetValues ( dialog,
                  XmNwidth, &width,
                  XmNheight, &height,
                  XmNborderWidth, &border,
                  NULL );

  XtVaSetValues ( dialog,
                  XmNminWidth,  width +  border,
                  XmNmaxWidth,  width +  border,
                  XmNminHeight, height + border,
                  XmNmaxHeight, height + border,
                  NULL );
  return (dialog);
}

void prefPostPreference()
{
  static Widget dialog = (Widget) NULL;

  if (dialog == (Widget)NULL)
    dialog = prefCreatePreference();

  XtManageChild (dialog);
  XtPopup (dialog, XtGrabNone);
}

/*
 * Handle the preferences for live update
 */
static void prefLiveUpdateToggle(Widget w, XtPointer client, XtPointer call)
{
	Boolean set = (((XmToggleButtonCallbackStruct *)call)->set == XmSET) ? True : False;
	XtSetSensitive(PrefLiveUpdateTF, set);
}
#endif

void prefSetLiveUpdateInterval(int i)
{
	static char	s[8];

	if (i < 0) {
		PrefLiveUpdateInterval = -i;
		PrefLiveUpdateSet = False;
	} else {
		PrefLiveUpdateInterval = i;
		PrefLiveUpdateSet = True;
	}

	if (PrefLiveUpdateTF) {
		XtSetSensitive(PrefLiveUpdateTF, PrefLiveUpdateSet);
		sprintf(s, "%d", i);
		XmTextFieldSetString(PrefLiveUpdateTF, s);
	}
	if (PrefLiveUpdateToggle)
		XmToggleButtonSetState(PrefLiveUpdateToggle, PrefLiveUpdateSet, False);

	if (PrefLiveUpdateSet) {
	}
}

int prefGetLiveUpdateInterval(void)
{
	if (PrefLiveUpdateSet)
		return PrefLiveUpdateInterval;
	return -PrefLiveUpdateInterval;
}
