/*
 * Copyright (c) 1997, 2000, Mark Buser.
 * Copyright (c) 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/help.c,v 1.7 2004/04/18 10:58:36 danny Exp $
 */
#include <stdio.h>

#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/PanedW.h>
#include <Xm/MessageB.h>

#include "xutil.h"

static Widget help_dialog;
static int isPoppedUp = False;

static char *helpStrings[] = {
#ifdef XQUOTE
#include "help-textXq.h"
#else
#include "help-textXi.h"
#endif
    NULL
};

static struct {
    int lineno;
    char *string;
} helpTopicInfo[] = {
#include "help-topic.h"
};


/* ARGSUSED */
static void loadtopic ( Widget w, XtPointer client_data, XtPointer call_data )
{
    Widget label;
    Widget text;
 
    XmString xstr;

    int    i;
    int    pos = 0;
    int    topic  = ((XmListCallbackStruct *) call_data)->item_position-1;

    /* Get the heading label and text help area widgets */
    XtVaGetValues (w, XmNuserData,  &label, NULL );
    XtVaGetValues (label, XmNuserData,  &text, NULL );

    xstr = XmStringCreateLocalized ( helpTopicInfo[topic].string );
    XtVaSetValues ( label, XmNlabelString, xstr, NULL );
    XmStringFree ( xstr );

    XmTextSetString ( text, "" );

    for ( i = helpTopicInfo[topic].lineno; helpStrings[i] != NULL; i++) {
       XmTextReplace ( text, pos, pos, helpStrings[i] );
       pos += strlen ( helpStrings[i] ); 
    }

}

/* ARGSUSED */
void helpCB ( Widget w, XtPointer client_data, XtPointer call_data ) 
{
  Widget pane, form, frame, list_w, text_w, heading, button;

  int pos = 0;
  int numHelpTopics;

  int		n;
  Arg		args[10];
  XmString	xms;

  Dimension width, height, border;

  if (help_dialog == NULL) {
	  /* Create dismiss button */
	  n = 0;
	  XtSetArg(args[n], XmNdeleteResponse, XmDESTROY); n++;
	  xms = XmStringCreateSimple("Dismiss");
	  XtSetArg(args[n], XmNcancelLabelString, xms); n++;

	  /* Create template dialog */
	  help_dialog = XmCreateTemplateDialog(GetTopShell(w), "Help", args, n);
	  form = XtVaCreateWidget ( "form1", xmFormWidgetClass, help_dialog, NULL );

    frame = XtVaCreateManagedWidget( "topicframe", xmFrameWidgetClass, form,
                                     XmNtopAttachment,    XmATTACH_FORM,
                                     XmNbottomAttachment, XmATTACH_FORM,
                                     XmNleftAttachment,   XmATTACH_FORM,
                                     NULL );

    XtVaCreateManagedWidget("Topics", xmLabelGadgetClass, frame,
                          XmNchildType,              XmFRAME_TITLE_CHILD,
                          XmNchildVerticalAlignment, XmALIGNMENT_CENTER,
                          NULL);

    /* scrolling list holding topics */
    n = 0;
    XtSetArg(args[n], XmNscrollVertical,   True); n++;
    XtSetArg(args[n], XmNscrollHorizontal, False); n++;
    XtSetArg(args[n], XmNselectionPolicy,  XmSINGLE_SELECT); n++;
    list_w = XmCreateScrolledList ( frame, "topiclist", args, n);
    
    XtAddCallback ( list_w, XmNsingleSelectionCallback, 
                            (XtCallbackProc) loadtopic, NULL );
    XtManageChild ( list_w );

    numHelpTopics = XtNumber(helpTopicInfo)-1;
    for (n=0; n < numHelpTopics; n++) 
      XmListAddItemUnselected( list_w,
                             XmStringCreateLocalized ( helpTopicInfo[n].string),
                             0 );


    frame = XtVaCreateManagedWidget( "textframe", xmFrameWidgetClass, form,
                                  XmNtopAttachment,    XmATTACH_FORM,
                                  XmNbottomAttachment, XmATTACH_FORM,
                                  XmNleftAttachment,   XmATTACH_WIDGET,
                                  XmNleftWidget,       frame,
                                  XmNrightAttachment,  XmATTACH_FORM,
                                  NULL );

    heading = XtVaCreateManagedWidget ("heading", xmLabelGadgetClass, frame,
                                 XmNchildType,              XmFRAME_TITLE_CHILD,
                                 XmNchildVerticalAlignment, XmALIGNMENT_CENTER,
                                 XtVaTypedArg, XmNlabelString, XmRString,
                                      helpTopicInfo[0].string,
                                      strlen(helpTopicInfo[0].string),
                                 NULL );


    /* Scrolled text widget actual help text */
    n = 0;
    XtSetArg(args[n], XmNscrollVertical,        True); n++;
    XtSetArg(args[n], XmNscrollHorizontal,      False); n++;
    XtSetArg(args[n], XmNeditMode,              XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n], XmNeditable,              False); n++;
    XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
    XtSetArg(args[n], XmNautoShowCursorPosition,  False); n++;
    XtSetArg(args[n], XmNwordWrap,  True); n++;
    text_w = XmCreateScrolledText( frame, "text", args, n);
  
    for ( n = helpTopicInfo[0].lineno; helpStrings[n] != NULL; n++) {
       XmTextReplace ( text_w, pos, pos, helpStrings[n] );
       pos += strlen ( helpStrings[n] ); 
    }

    XtManageChild( text_w );

    /* Remember label so we can set it from selected topic */
    XtVaSetValues (list_w, XmNuserData,  heading, NULL );
    /* Remember text so we can set it from selected topic */
    XtVaSetValues (heading, XmNuserData,  text_w, NULL );

    XtManageChild ( form );

    XtVaGetValues ( help_dialog, XmNwidth, &width,
                                 XmNheight, &height,
                                 XmNborderWidth, &border,
                    NULL );

    XtVaSetValues ( help_dialog, 
                    XmNminWidth,  width +  border,
                    XmNminHeight, height + border,
                    NULL );
  }
  
  XtManageChild (help_dialog);
  isPoppedUp = True;
}
