/*
 * Copyright (c) 1994, 1995, 1996, Mark Buser.
 * Copyright (c) 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/graph.h,v 2.4 2003/11/19 19:35:10 danny Exp $
 */
#define LEGEND_WIDTH 25
#define LEGEND_HEIGHT 15
#define LEGEND_INIT -1

void makeLegend ( Widget, int, Pixel);  /* Make a legend for a plot variable */
void displayGraph (int);         /* Show plot legends for account */
void plot ( Widget, Pixmap, GC); /* Drawing routine for plot */
int  getVActive();               /* Returns number of plots in graph */
void graphSense( int );          /* Set graph options sensitive if param != 0 */


/* Callbacks */
void  graph_pselect();                  /* graph mode selection */
void  graph_hselect();                  /* graph type selection */
void  graph_vselect();                  /* graph variable selection */
void  graph_option();                   /* Set optional feature of plot */
void  graph_slide();
void  const_change();
void  graphTraverse();                  /* TAB traverse to obscured list item */

#define PRICE         1
#define SHARE         2
#define COST          3
#define VALUE         4
#define DISTRIB       5
#define IRRRATE       6
#define TRRATE        7 
#define CONST         8
#define SHARE_CUM     9
#define COST_CUM     10
#define VALUE_CUM    11
#define DISTRIB_CUM  12 
#define PRICE_MAVG   13
#define SHARE_MAVG   14
#define COST_MAVG    15
#define DISTRIB_MAVG 16
#define RATE_MAVG    17

#define NUM_PLOTS   DISTRIB_MAVG

/* Account code needs to see this definition, since it gets to store it */
typedef struct toggle_attrib {
   unsigned valid;
   int attrib[NUM_PLOTS];
} PLOT_VAR;

PLOT_VAR *makeGraphVar ();       /* Create an initialize plot attributes */

