/***************************************************************************
                          window.h  -  description
                             -------------------
    begin                : Sat Jun 23 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __WINDOW_H
#define __WINDOW_H

/* list of all special id's used */
enum {
    /* if there's just one label use this id */
    ID_LABEL = 101,
    /* upper/lower bar labels */
    ID_LEFT_LABEL,
    ID_MIDDLE_LABEL,
    ID_RIGHT_LABEL,
    ID_STATUS_LABEL,
    ID_EXP_LABEL,
    ID_NAME_LABEL,
    ID_CAP_LABEL,
    ID_UPPER_LABEL,
    ID_LOWER_LABEL,
    /* lower bar buttons */
    ID_MENU_BUTTON,
    ID_STRAT_MAP_BUTTON,
    ID_AIR_BUTTON,
    ID_END_TURN_BUTTON,
    ID_AIR_MODE_BUTTON,
    ID_UNDO_BUTTON,
    ID_EMBARK_BUTTON,
    ID_SUPPLY_BUTTON,
    ID_RENAME_BUTTON,
    ID_SCEN_INFO_BUTTON,
    ID_DEPLOY_BUTTON,
    ID_MERGE_BUTTON,
    /* icons */
    ID_ATTACK_ICON,
    ID_MOVE_ICON,
    /* edit window */
    ID_EDIT,
    /* game menu ids */
    ID_SAVE_MENU,
    ID_LOAD_MENU,
    ID_OPTIONS,
    ID_RESTART,
    /* save/Load menu */
    ID_SLOT1,
    /* additional options menu buttons */
    ID_GRID_BUTTON,
    ID_CPU_BUTTON,
    ID_WEATHER_BUTTON,
    ID_LIFE_BAR_BUTTON,
    ID_SOUND_BUTTON,
    ID_SOUND_VOLUME_SCROLL,
    ID_MUSIC_BUTTON,
    ID_MUSIC_VOLUME_SCROLL,
	//main menu buttons//
	ID_SCEN_MENU,
	ID_CAMP_MENU,
	ID_PACK_MENU,
	ID_FILE_LIST,
	ID_DESC_LIST,
	ID_SCEN_SET,
	ID_EDIT_MENU,
	//scen info ids //
	ID_TITLE_LABEL,
	ID_INFO_LIST,
	/* option buttons */
	ID_MODE_BUTTON,
	/* deploy window */
	/* ID_INFO_LIST as above */
	ID_DEPLOY_UNIT,
	ID_APPLY_DEPLOY,
	ID_CANCEL_DEPLOY,
	ID_UNIT_SCROLL,
	/* MUST BE THE VERY LAST ID */
	ID_UNIT_ICON1
};


/* list of parent window id's (not set as id but used to specify window in run_window(...) ) */
enum {
    ID_MENU = 1,
    ID_INFO,
    ID_STRAT_MAP,
    ID_CONF_END_TURN,
    ID_UNIT_INFO,
    ID_RENAME_UNIT,
    ID_SCEN_INFO,
    ID_DEPLOY_UNITS
};

/* create windows by using current theme */
/* NOTE: to change theme you must delete/recreate engine!!!! */
void create_windows( Engine *engine );

/* called in delete_engine to delete all created windows */
void delete_windows( Engine *engine );

/* check window_id and run the appropiate window */
int run_window( Engine *engine );

/* run window and only check if ACCEPT or CANCEL is the result */
int run_stan_window( Window *window );

/* run menu includes the handling of all subwindows, too
this means handling of options/saving/resuming games */
void run_menu( Engine *engine );

/* run save/load menu and allow the action defined by type: ID_SAVE_MENU,ID_LOAD_MENU */
void run_save_menu( Engine *engine, int type );

/* update edit window; set label, exit contents and max length */
void update_edit_window( Engine *engine, char *label_str, char *edit_str, int max );

/*
====================================================================
Run options window.
====================================================================
*/
void prep_options_window( Engine *engine );
int run_options_window( Engine *engine, Video_Mode *new_mode );
void apply_options( Engine *engine );

/*
====================================================================
Run video mode window.
====================================================================
*/
Window *create_mode_window( Theme *theme );
int run_mode_window( Engine *engine, int *mode_id );

/*
====================================================================
Create upper/lower bar.
====================================================================
*/
void create_upper_bar( Engine *engine );
void create_lower_bar( Engine *engine );

/*
====================================================================
Deploy units window
====================================================================
*/
Window* create_deploy_window( Engine *engine );
void prep_deploy_window( Engine *engine );
enum {
    /* types */
    DEPLOY_UNIT, /* returned unit becomes selected unit for deployment */
    APPLY_DEPLOY, /* apply deploy changes */
    CANCEL_DEPLOY /* cancel deployed changes */
};
void run_deploy_window( Engine *engine, int *type, Unit **unit );

#endif
