/***************************************************************************
                          scenario.h  -  description
                             -------------------
    begin                : Fri Jan 19 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __SCENARIO_H
#define __SCENARIO_H

/* contains the scenario struct and functions to handle it */

/* prepare unit flags */
enum {

    NO_FUEL_CHECK = ( 1L << 1 ),
    NO_ENTR_CHECK = ( 1L << 2 )

};

/* attacking team */
enum {
    FIRST_TEAM = 0,
    SECOND_TEAM
};

typedef struct {
    int x, y;
} Prim_Obj;

/* either all or a single condition must be fullfilled */
enum {
    ONE_COND = 0,
    ALL_COND
};

/* victory conditions */
typedef struct {
    int req_obj_count; /* number of required mil objectives to win scenario */
    int prim_obj_count;
    Prim_Obj *prim_obj; /* position on map */
    int type; /* all or at least one condition needed to win? */
} Victory_Cond;


/* scenario struct */
typedef struct {
    /* scenario knows it's own file_name */
    char *file_name;

    /* info */
    char *title;
    char *desc; /* description */
    char *authors; /* a string with all author names */
    Date date;
    int major_turn_limit; /* glorious victory turn limit */
    int minor_turn_limit; /* victory turn limit */

    /* nations */
    int nation_count;
    Nation **nations;

    /* map is global definition in map.c */
    int *weather; /* contains weather information for each day */

    /* players stuff */
    int player_count;
    Player **players;
    Player **first_team;
    int first_team_count;
    Player **second_team;
    int second_team_count;
    /* either first or second team is the attacker */
    /* victory conditions are set for the attacker; if he fails to reach these
    objectives within minor turn limit the defender has won */
    int att_team;
    Victory_Cond victory_cond;
    int att_team_won; /* set if attacking team fullfilled victory conditions */
    int human_is_att; /* check for the first human player and set if attacker;
    used to compute next scenario when playing campaign because a campaign is always
    played by just one human player */

    /* units */
    Unit_Def *unit_def; /* unit definitions */
    Dyn_List unit_lib; /* unit library */
    Dyn_List units; /* units */
    Dyn_List reinf; /* reinforcements: unit with delays */

    /* stuff that changes while playing */
    int cur_turn; /* 0 <= cur_turn < vic_turn_limit */
    int rem_turns; /* vic_turn_limit >= rem_turns > 0 -- remaining turns */
} Scen;


enum {
    SHALLOW = 0,
    DEEP = 1
};
/* load scenario by reading information from file */
/* if type is SHALLOW only entries from this scenario file are loaded; if type is DEEP then links will
be resolved (graphics, maps, units) */
/* SRC_Dir/scenarios is added when with_src_dir is set */
int load_scen( char *scen_name, int type );

/* frees memory allocated by scen */
void clear_scen( );

/* prepare unit for turn */
void prep_unit_for_turn( Unit *unit, int turn, int flags );

/* check if player belongs to attacking team */
int is_att( Player *player );

/* check if victory conditions are fullfilled and set scen::att_team_won */
void check_victory_cond( );

/* get attacking team */
Player **get_att_team( int *count );

// compute supply level of all units belonging to this player_id //
void comp_unit_supply_level( Unit *unit );

#endif
