/***************************************************************************
                          main.c  -  description
                             -------------------
    begin                : Mit Jan 17 16:03:18 CET 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include <SDL.h>
#ifdef WITH_SOUND
#include <SDL_mixer.h>
#include "audio.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sdl.h"
#include "config.h"
#include "tools.h"
#include "dynlist.h"
#include "file.h"
#include "nation.h"
#include "unit.h"
#include "player.h"
#include "date.h"
#include "map.h"
#include "scenario.h"
#include "gui.h"
#include "theme.h"
#include "ai_action.h"
#include "engine_tools.h"
#include "engine.h"
#include "main_menu.h"

/* oh no! someone called for a hack??? shit I'm too lazy to implement this properly
this sound pointer MUST be set before any window is created if this window is supposed
to have sound. right now this sound is in this file after the theme was created */
#ifdef WITH_SOUND
extern Sound_Chunk *click_sound;
extern Sound_Chunk *edit_sound;
#endif

int term_game = 0;
extern Sdl sdl;
extern Scen scen;
extern Config config;

int main(int argc, char *argv[])
{
    Theme *theme = 0;
    Engine *engine = 0;
    char window_name[32];

    /* display some credits */
    printf( "LGeneral %s\nCopyright 2001 Michael Speck\nPublished under GNU GPL\n---\n", VERSION );
    printf( "Looking up data in: %s\n", SRC_DIR );
#ifndef WITH_SOUND
    printf( "Compiled without sound and music\n" );
#endif

    /* check config directory path and load config */
    check_config_dir_name();
    load_config();

    /* init sdl */
    init_sdl( SDL_INIT_VIDEO | SDL_INIT_TIMER | SDL_INIT_AUDIO );
    set_video_mode( config.video_mode );
    sprintf( window_name, "LGeneral %s", VERSION );
    SDL_WM_SetCaption( window_name, 0 );

#ifdef WITH_SOUND
    /* initiate audio device */
    audio_open();
    sound_enable( config.sound_on );
    sound_volume( config.sound_volume );
    music_volume( config.music_volume );
#endif

    /* set random seed */
    set_random_seed();

    /* initiate engine */
    theme = load_theme( "standard" );
    if ( !theme ) exit( 1 );

#ifdef WITH_SOUND
    click_sound = theme->click_sound;
    edit_sound = theme->edit_sound;
#endif

    engine = create_engine( theme );
    if ( !engine ) exit ( 1 );

	/* run title menu */
	run_title_window( engine );
	
    /* delete stuff */
    delete_engine( engine );
    delete_theme( theme );

#ifdef WITH_SOUND
    /* close audio device */
    audio_close();
#endif

    /* save settings */
    save_config();

    return 0;
}
