/***************************************************************************
                          engine.h  -  description
                             -------------------
    begin                : Sat Feb 3 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ENGINE_H
#define __ENGINE_H

/*
    this file contains the major engine functions
    all other tool functions which might be useful to AI can be found
    in engine_tools.h
    also the struct itself is defined there
*/

/* create engine -- get mem and set scen and theme pointer and create windows */
Engine *create_engine( Theme *theme );

/* delete engine completly */
void delete_engine( Engine *engine );

/* prepare engine (eg set dyn variables etc ) */
/* if player_cont is not 0 overwrite the default control values */
int init_engine( Engine *engine, char *scen_name, int *player_cont );

/*
free used memory allocated by init_engine ( not create_engine! )
must be called after running engine and before initiating next scenario
*/
void clear_engine( Engine *engine );

/* run engine return values - refers to attackers success */
enum {
    /* NONE */
    DEFEAT = 1,
    MAJOR_VIC,
    MINOR_VIC
};
/* run engine -- run game - return who won */
int run_engine( Engine *engine );

/* draw map tile flags -- used to check if unit is dran/ fogged etc */
enum {
    DRAW_FOG = ( 1L << 1 ), /* use map::mask::fog */
    DRAW_MOVE_RANGE = ( 1L << 2 ), /* use map::mask::in_range */
    DRAW_UNIT = ( 1L << 3 ),
    DRAW_GROUND_UNIT = ( 1L << 4 ),
    DRAW_AIR_UNIT = ( 1L << 5 ),
    DRAW_SMALL_GROUND_UNIT = ( 1L << 6 ),
    DRAW_SMALL_AIR_UNIT = ( 1L << 7 ),
    NO_SEL_FRAME = ( 1L << 8 ),
    DRAW_CROSS = ( 1L << 9 ),
    DRAW_MERGE_MASK = ( 1L << 10 ), /* use merge unit mask */
    DRAW_DEPLOY_MASK = ( 1L << 11 ),
    DRAW_FORCED_FOG = ( 1L << 12) /* force shadow */
};
/* draw map tile */
void draw_map_tile( Engine *engine, int map_x, int map_y, int screen_x, int screen_y, int flags, int ref );
/* draw unit ( on map tile ) */
void draw_unit( Engine *engine, int map_x, int map_y, int screen_x, int screen_y, int flags, int ref );
/* redraw map tile and unit by getting position first; only use for updating single tiles */
void update_map_tile( Engine *engine, int map_x, int map_y, int flags );

/* update map by checking action/status types and change the screen buffer */
void update_map( Engine *engine, int ms );

/* simply update full map */
void update_full_map( Engine *engine, int clip );

/* update map tile info */
void update_map_tile_info( Engine *engine, int x, int y );

/* update unit info */
void update_unit_info( Engine *engine, int x, int y );

/* update cursor */
void update_cursor( Engine *engine, int x, int y );

/* goto to map position */
void goto_map_pos( Engine *engine, int x, int y, int type );

/* set action to scroll map and update position and cursor if needed */
void scroll_map_by_mouse( Engine *engine, int x, int y );

/* set action to scroll map and update position and cursor if needed */
void scroll_map_by_key( Engine *engine, int scroll_dir );

/* various engine tool functions */
/* all other tool functions might be found in engine_tools.h */

/* set player id, pointer and cont_status */
void set_player( Engine *engine, int player_id );

/* end turn, display summary and select next player */
void end_turn( Engine *engine );

/* get unit by map or mouse position */
Unit *get_unit( Engine *engine, int x, int y, int pos_type, int unit_type );

/* get absolute map position from mouse position */
int get_map_pos( Engine *engine, int mouse_x, int mouse_y, int *map_x, int *map_y );

/* get screen position from absolute map position */
int get_screen_pos( Engine *engine, int map_x, int map_y, int *screen_x, int *screen_y );

/* select unit by mouse */
int select_unit_by_mouse( Engine *engine, int mouse_x, int mouse_y );

/* clear way points */
inline void clear_way_points( Way_Point **way );

/* initiate movement */
int start_unit_move( Engine *engine, int x, int y );

/* check unit buttons status */
void check_unit_buttons( Engine *engine );

/* start sel_unit attack */
int start_unit_attack( Engine *engine, int map_x, int map_y );

/* ambush selected unit with unit */
int start_unit_ambush( Engine *engine );

/* remove unit completely */
void remove_unit( Engine *engine, Unit *unit );

/* confirm that ground transporter should be abandoned */
int aban_ground_tran( Engine *engine, Unit *unit );

/* draw pre-turn info: turn count, weather, current player */
void draw_turn_info( Engine *engine );

/* update map + upper/lower bar */
void update_full_screen( Engine *engine );

/*
reinit_engine() must be run after loading a scenario; it updates all variables
according to engine::player_id and draws a turn startup team */
void reinit_engine( Engine *engine );

/* reload scenario and restart */
void restart_scen( Engine *engine );

/* update and run briefing window */
void run_brief_window( Engine *engine, char *text );

/*
====================================================================
This function handles the AI turn. It calls ai_get_action() or
restores a stored action and initate the engine to execute this
action.
====================================================================
*/
void ai_handle( Engine *engine );

/*
====================================================================
Runs the strategic map.
====================================================================
*/
void run_strat_map( Engine *engine );

/*
====================================================================
Apply nescessary changes when setting resolution.
====================================================================
*/
void apply_video_mode( Engine *engine );

/*
====================================================================
Activate button if reinfs left else deactivate.
====================================================================
*/
void check_deploy_button( Engine *engine );

/*
====================================================================
Run confirm window and return true if accepted else 0.
====================================================================
*/
int run_conf_window( Engine *engine, char *str1, char *str2 );

#endif
