/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.eclipse;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.command.internal.env.core.EnvironmentCoreMessages;
import org.eclipse.wst.command.internal.env.ui.dialog.MessageDialog;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.environment.StatusException;

public class EclipseStatusHandler
implements IStatusHandler {
    private IStatus worstStatus = Status.OK_STATUS;
    private Shell shell = null;

    public EclipseStatusHandler() {
    }

    public EclipseStatusHandler(Shell theShell) {
        this.shell = theShell;
    }

    public IStatus getStatus() {
        return this.worstStatus;
    }

    public void resetStatus() {
        this.worstStatus = Status.OK_STATUS;
    }

    public Choice report(final IStatus status, final Choice[] choices) {
        final int[] result = new int[1];
        this.checkStatus(status);
        Runnable runnable = new Runnable(){

            public void run() {
                result[0] = MessageDialog.openMessage(EclipseStatusHandler.this.getShell(), EnvironmentCoreMessages.TITLE_WARNING, null, status, choices);
            }
        };
        Display.getDefault().syncExec(runnable);
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getShortcut() == result[0]) {
                return choices[i];
            }
            ++i;
        }
        return null;
    }

    public void report(IStatus status) throws StatusException {
        boolean userOk = false;
        this.checkStatus(status);
        switch (status.getSeverity()) {
            case 4: {
                userOk = this.reportErrorStatus(status);
                break;
            }
            case 2: {
                userOk = this.reportWarning(status);
                break;
            }
            case 1: {
                userOk = true;
                this.reportInfo(status);
            }
        }
        if (!userOk) {
            throw new StatusException(status);
        }
    }

    private boolean reportWarning(final IStatus status) {
        final int[] userResponse = new int[1];
        Runnable runnable = new Runnable(){

            public void run() {
                userResponse[0] = MessageDialog.openMessage(EclipseStatusHandler.this.getShell(), EnvironmentCoreMessages.TITLE_WARNING, null, status);
            }
        };
        Display.getDefault().syncExec(runnable);
        return userResponse[0] == 0;
    }

    private boolean reportErrorStatus(final IStatus status) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openMessage(EclipseStatusHandler.this.getShell(), EnvironmentCoreMessages.TITLE_ERROR, null, status);
            }
        };
        Display.getDefault().syncExec(runnable);
        return false;
    }

    private void checkStatus(IStatus status) {
        if (status.getSeverity() > this.worstStatus.getSeverity()) {
            this.worstStatus = status;
        }
    }

    public void reportError(IStatus status) {
        this.checkStatus(status);
        this.reportErrorStatus(status);
    }

    public void reportInfo(final IStatus status) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openMessage(EclipseStatusHandler.this.getShell(), EnvironmentCoreMessages.TITLE_INFO, null, status);
            }
        };
        Display.getDefault().syncExec(runnable);
    }

    private Shell getShell() {
        if (this.shell != null) {
            return this.shell;
        }
        Display display = Display.getDefault();
        return display == null ? null : display.getActiveShell();
    }
}

