/* $Id: conf.h,v 1.20 2004/02/26 14:25:49 onoe Exp $ */

/*-
 * Copyright (c) 1998-1999 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * User Configuration (Parameters)
 */

/* default commands (%s=folder_dir, %d=msgnum) */
#define	DEF_INC		"inc -silent +%s"	/* inc command */
#define	DEF_SEND	"sendmail -t -i"	/* sendmail (read stdin) */
#define	DEF_EDITOR	"vi +/^$/ %s/%s"	/* editor */

		/*	msg# M = date  from     subject <<body */
#define	SCAN_FMT	"%*s %c%-6.6s %-15.15s  "
#define	MARK_DELETE	'D'		/* delete mark */
#define	MARK_REFILE	'^'		/* refile mark */
#define	MARK_MARK	'*'		/* message mark */

#define	NOTE_SIGNED	'S'		/* signed note (%c) */
#define	NOTE_VERIFIED	's'		/* verified note (%c) */
#define	NOTE_ENCRYPTED	'E'		/* encrypted note (%c) */
#define	NOTE_DECRYPTED	'e'		/* decrypted note (%c) */
#define	NOTE_MULTI	'M'		/* multipart note (%c) */
#define	NOTE_FORWARD	'F'		/* forwarded note (%c) */
#define	NOTE_REPLIED	'-'		/* replied note (%c) */

#define	LINE_WIDTH	80		/* should not resize */

#define	MAX_REFILE	4		/* max number of destination */

#define	CONFFILE	".cuerc"	/* configuration file in HOME */
#define	SUF_INFO	".info"		/* suffix for draft info file */
#define	SUF_BAK		".bak"		/* suffix for draft backup file */

#define	DEF_NUMWIDTH	5		/* width of message number */
#define	DEF_WINSIZE	"1/8"		/* the percentage for index window */
#define	DEF_FOLDER	"+inbox"	/* initial & inc */
#define	DRAFT_FOLDER	"+drafts"	/* edit & send */

#define	DEF_STATFILE	".cuestat"	/* status information file. */
#define	DEF_STATBACKUP	FALSE		/* status information file. */
#define	DEF_MAILCAP	".mailcap"	/* configuration for multimedia mail */

#define	DEF_DELAY	1000		/* delay to press next key */
#define	KANJI_TIMEOUT	1000		/* getting second char of KANJI */

/*
 * System Configuration, Performance
 */
#define	FDB_CACHE	100		/* number of cached file */
#define	LINEBLOCK	100		/* unit to parse line */
#define	CHARBLOCK	1000		/* unit of convert buffer allocation */
#define	MAXARGS		20		/* max argument for command */
#define	MAXPATH		1024		/* max length of path name */
