/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#ifndef CLIENT_H
#define CLIENT_H
#include "global.h"
#include "options.h"
#include "menu.h"


#define CF_SHADED 1
#define CF_IGNOREEXPOSE 2
#define CF_FIXEDSIZE 4
#define CF_ICONPOSKNOWN 8
#define CF_GRABBED 16
#define CF_NOCLOSE 32
#define CF_NOMINIMIZE 64
#define CF_MWM_NOTITLE 128
#define CF_STICKY 256

#ifdef SHAPE
#define CF_HAS_BEEN_SHAPED 512
#endif

#define R_WITHDRAW 0
#define R_REMAP 1

#define SPACE 1
#define BUTTONWIDTH THeight


// modes for raise

#define R_PARENT 1
#define R_MOVEMOUSE 2
#define R_INDIRECT 4

#define snap 6

#define S_LEFT 1
#define S_RIGHT 2

#define S_TOP 4
#define S_BOTTOM 8

// Defines for Maximize
#define MAX_UNMAX 0
#define MAX_HALF 1
#define MAX_FULL 2
#define MAX_REMAX 3
#define MAX_FULLSCREEN 4

// Defines for MH->type
#define T_B1     1
#define T_B2     2
#define T_B3     3
#define T_DC     8  // Doubleclick
#define T_SDC    16 // Strange doubleclick
#define T_BAR    32
#define T_F1     64
#define T_F2     96
#define T_SHIFT 128

#define T_BUTTON (T_BAR|T_F1|T_F2)
#define T_MOUSEBUTTON (T_B1|T_B2|T_B3)


class Client : public TWindow {
  public:
    Client(Desktop *, Options *);
    Client(Desktop *, Options *,ClientInfo *, Window);
    virtual bool Init();
    void GetMWMOptions();
    virtual ~Client();
    virtual Client* FindPointerClient();
    virtual bool GetWindowList(MenuItem *,int &,bool,int,int,int);
    virtual void RemoveClientReferences(Client *);
    virtual Desktop *DesktopAbove();
    void ChangeName();
    void UpdateName(bool);
    void ReDrawTBEntry(Client *,bool=true);
    virtual void SendWMDelete(bool);
    virtual void RequestDesktop();
    void Maximize(int);
    void Shade();
    virtual unsigned long GetRegionMask(int,int,Client * &);
    virtual void SetWMState();
    virtual void GrabButtons(bool = false);
    void GiveFocus();
    virtual void GetFocus();
    virtual bool Leave(int,int,bool);
    virtual Client *Focus();
    Client* Next(bool);
    Client* Prev(bool);
    void MoveRight();
    void MoveLeft();
    void MoveUp();
    void MoveDown();
    void StackingUp();
    void StackingDown();
    virtual void Raise(int);
    void Lower(bool);
    void Map();
    void Unmap();
    long GetWMState();
    virtual void SendConfig();
    void Configure(XConfigureRequestEvent);
    void InitPosition();
    void Gravitate(int);
    void Reparent();
    virtual void Remove(int);
    void Hide();
    void ToggleHasTitle();
    virtual void UpdateTB();
    virtual void ReDraw();
    void DrawOutline();
    void MoveResize(int,int, bool, int, int);
    void Snap(int);
    void RecalcSweep(int);
    virtual void ChangeSize();
    void ChangePos();
    void Clear();
#ifdef SHAPE
    void MakeHole(bool);
    void SetShape();
#endif
#ifdef DEBUG
    const char *ShowGrav();
    const char *ShowState();
    void dump();
#endif


    Client *next;
    Desktop *parent,*target;
    char	*name, *wmname;
    bool mapped; // Is the window mapped?
    bool visible; // Is the window visible?
    int THeight;
    Window	window, frame, title;

    Client *trans,*transfor;
//  protected:

    ClientInfo *ci;
    int TBx, TBy, TBEx, TBEy;

    int MaxX,MaxY,MaxW,MaxH;

    XSizeHints	*size;
    Colormap cmap;
    int	x, y, width, height;
    int x_root, y_root;
    int IconX,IconY;

    int stacking;

    Icon *icon;
    RPixmap *iconpm;
    Options o;

};


void get_mouse_position(Window w, int &x, int &y);


#define setmouse(w, x, y) XWarpPointer(dpy, None, w, 0, 0, 0, 0, x, y)
#define grabp(w, mask, curs) (XGrabPointer(dpy, w, False, mask, \
    GrabModeAsync, GrabModeAsync, None, curs, CurrentTime) == GrabSuccess)


#endif
