/*
**  Copyright (c) 2004-2006 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: dk-filter.h,v 1.86 2006/06/14 18:42:57 msk Exp $
*/

#ifndef _DK_FILTER_H_
#define _DK_FILTER_H_

#ifndef lint
static char dk_filter_h_id[] = "@(#)$Id: dk-filter.h,v 1.86 2006/06/14 18:42:57 msk Exp $";
#endif /* !lint */

#define	DKF_PRODUCT	"Sendmail DomainKeys Filter"
#define	DKF_VERSION	"0.4.1"

/* libdk */
#include <dk.h>

/* make sure we have TRUE and FALSE */
#ifndef FALSE
# define FALSE		0
#endif /* !FALSE */
#ifndef TRUE
# define TRUE		1
#endif /* !TRUE */

/* defaults, limits, etc. */
#define	BUFRSZ		256
#define CMDLINEOPTS	"a:Ab:c:C:d:DfFhHi:I:klm:M:o:p:P:rRs:S:T:u:U:V"
#define	DEFTIMEOUT	5
#define	HEADERMARGIN	75
#define	HOSTUNKNOWN	"unknown-host"
#define	JOBIDUNKNOWN	"(unknown-jobid)"
#define	LOCALHOST	"127.0.0.1"
#define	MAXADDRESS	256
#define	MAXARGV		65536
#define	MAXHDRLEN	78
#define	MAXHEADER	1000
#define	MAXSIGNATURE	1024
#define	TEMPFILE	"/var/tmp/dkXXXXXX"
#define	UNKNOWN		"unknown"

#define AUTHRESULTSHDR	"Authentication-Results"

#define	XHEADERNAME	"X-DomainKeys"
#define	XSELECTCANONHDR	"X-Canonicalization"

/*
**  PEER -- peer list, listing clients to ignore
*/

typedef struct Peer * Peer;
struct Peer
{
	char *		peer_info;
	struct Peer *	peer_next;
};

/* externs */
extern char *progname;

#endif /* _DK_FILTER_H_ */
