/* $Id: proto_crafty.cc,v 1.22 2002/02/13 03:53:56 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "eboard.h"
#include "global.h"
#include "network.h"
#include "protocol.h"
#include "chess.h"
#include "status.h"
#include "util.h"

CraftyProtocolParser::CraftyProtocolParser() : XBoardProtocolParser() {
  strcpy(ComputerName,"Crafty");
  want_path_pane=0;
}

char * CraftyProtocolParser::getDialogName() {
  return("Play against Crafty");
}

void CraftyProtocolParser::readDialog() {
  char *p;
  XBoardProtocolParser::readDialog();
  resolvePaths();
  sprintf(EngineCommandLine,"crafty bookpath=%s logpath=%s tbpath=%s",
	  BookPath,LogPath,LogPath);
  p=getenv("HOME");
  if (p)
    sprintf(EngineRunDir,"%s/.eboard/craftylog",p);
  else
    strcpy(EngineRunDir,"/tmp");
}

void CraftyProtocolParser::initEngine() {
  global.network->writeLine("log off");
  XBoardProtocolParser::initEngine();
}

// keep this and Documentation/Crafty.txt coherent
void CraftyProtocolParser::resolvePaths() {
  FileFinder ff;
  char z[256],zz[256],*p;

  // book path
  p=getenv("HOME");
  if (p) sprintf(z,"%s/.eboard",p); else strcpy(z,"/tmp");

  ff.addMyDirectory(".eboard");
  ff.addMyDirectory(".");
  ff.addDirectory("/usr/local/share/eboard");
  ff.addDirectory("/usr/share/eboard");
  ff.addDirectory("/usr/local/share/crafty");
  ff.addDirectory("/usr/share/crafty");

  if (ff.find("book.bin",zz)) {
    p=rindex(zz,'/');
    *p=0;
  } else
    strcpy(zz,z);

  strcpy(BookPath,zz);

  // log path
  p=getenv("HOME");
  if (p) sprintf(z,"%s/.eboard/craftylog",p); else strcpy(z,"/tmp");
  strcpy(LogPath,z);
}

