/* GtkamlParser.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlParser.h"
#include <glib/gstdio.h>
#include <vala/valacodevisitor.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include "GtkamlImplicitsStore.h"
#include "GtkamlSAXParser.h"
#include "GtkamlRootClassDefinition.h"
#include "GtkamlImplicitsResolver.h"
#include "GtkamlClassDefinition.h"
#include "GtkamlCodeGenerator.h"




struct _GtkamlParserPrivate {
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	GtkamlImplicitsStore* implicits_store;
};

#define GTKAML_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_PARSER, GtkamlParserPrivate))
enum  {
	GTKAML_PARSER_DUMMY_PROPERTY
};
static void gtkaml_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void gtkaml_parser_real_parse_gtkaml_file (GtkamlParser* self, ValaSourceFile* gtkaml_source_file);
static gpointer gtkaml_parser_parent_class = NULL;
static void gtkaml_parser_finalize (GObject * obj);



GtkamlParser* gtkaml_parser_new (void) {
	GtkamlParser * self;
	self = g_object_newv (GTKAML_TYPE_PARSER, 0, NULL);
	return self;
}


void gtkaml_parser_parse (GtkamlParser* self, ValaCodeContext* context, char** implicits_directories) {
	ValaCodeContext* _tmp3;
	ValaCodeContext* _tmp2;
	g_return_if_fail (GTKAML_IS_PARSER (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	if (implicits_directories != NULL) {
		{
			char** implicits_dirs_collection;
			int implicits_dirs_collection_length1;
			char** implicits_dirs_it;
			implicits_dirs_collection = implicits_directories;
			implicits_dirs_collection_length1 = -1;
			for (implicits_dirs_it = implicits_dirs_collection; *implicits_dirs_it != NULL; implicits_dirs_it = implicits_dirs_it + 1) {
				const char* _tmp0;
				char* implicits_dirs;
				_tmp0 = NULL;
				implicits_dirs = (_tmp0 = *implicits_dirs_it, (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
				{
					gtkaml_implicits_store_add_implicits_dir (self->priv->implicits_store, implicits_dirs);
					implicits_dirs = (g_free (implicits_dirs), NULL);
				}
			}
		}
	}
	{
		char** datadir_collection;
		int datadir_collection_length1;
		char** datadir_it;
		datadir_collection = g_get_system_data_dirs ();
		datadir_collection_length1 = -1;
		for (datadir_it = datadir_collection; *datadir_it != NULL; datadir_it = datadir_it + 1) {
			const char* _tmp1;
			char* datadir;
			_tmp1 = NULL;
			datadir = (_tmp1 = *datadir_it, (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
			{
				char* filename;
				filename = g_build_filename (datadir, "gtkaml", "implicits", NULL);
				if (g_file_test (filename, G_FILE_TEST_EXISTS)) {
					gtkaml_implicits_store_add_implicits_dir (self->priv->implicits_store, filename);
				}
				datadir = (g_free (datadir), NULL);
				filename = (g_free (filename), NULL);
			}
		}
	}
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->context = (_tmp3 = (_tmp2 = context, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL))), _tmp3);
	vala_parser_parse (VALA_PARSER (self), context);
}


static void gtkaml_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	GtkamlParser * self;
	self = GTKAML_PARSER (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	if (g_str_has_suffix (vala_source_file_get_filename (source_file), ".vala") || g_str_has_suffix (vala_source_file_get_filename (source_file), ".vapi")) {
		VALA_CODE_VISITOR_CLASS (gtkaml_parser_parent_class)->visit_source_file (VALA_CODE_VISITOR (VALA_PARSER (self)), source_file);
	} else {
		if (g_str_has_suffix (vala_source_file_get_filename (source_file), ".gtkaml")) {
			gtkaml_parser_parse_gtkaml_file (self, source_file);
		}
	}
}


static void gtkaml_parser_real_parse_gtkaml_file (GtkamlParser* self, ValaSourceFile* gtkaml_source_file) {
	GError * inner_error;
	g_return_if_fail (GTKAML_IS_PARSER (self));
	g_return_if_fail (VALA_IS_SOURCE_FILE (gtkaml_source_file));
	inner_error = NULL;
	if (g_file_test (vala_source_file_get_filename (gtkaml_source_file), G_FILE_TEST_EXISTS)) {
		{
			ValaSourceFile* dummy_file;
			GtkamlSAXParser* sax_parser;
			GtkamlRootClassDefinition* root_class_definition;
			GtkamlImplicitsResolver* implicitsResolver;
			GtkamlCodeGenerator* code_generator;
			char* vala_contents;
			dummy_file = vala_source_file_new (self->priv->context, vala_source_file_get_filename (gtkaml_source_file), FALSE);
			sax_parser = gtkaml_sax_parser_new (self->priv->context, dummy_file);
			root_class_definition = gtkaml_sax_parser_parse (sax_parser);
			if (vala_report_get_errors () != 0) {
				(dummy_file == NULL ? NULL : (dummy_file = (g_object_unref (dummy_file), NULL)));
				(sax_parser == NULL ? NULL : (sax_parser = (g_object_unref (sax_parser), NULL)));
				(root_class_definition == NULL ? NULL : (root_class_definition = (g_object_unref (root_class_definition), NULL)));
				return;
			}
			implicitsResolver = gtkaml_implicits_resolver_new (self->priv->context, self->priv->implicits_store);
			gtkaml_implicits_resolver_resolve (implicitsResolver, GTKAML_CLASS_DEFINITION (root_class_definition));
			if (vala_report_get_errors () != 0) {
				(dummy_file == NULL ? NULL : (dummy_file = (g_object_unref (dummy_file), NULL)));
				(sax_parser == NULL ? NULL : (sax_parser = (g_object_unref (sax_parser), NULL)));
				(root_class_definition == NULL ? NULL : (root_class_definition = (g_object_unref (root_class_definition), NULL)));
				(implicitsResolver == NULL ? NULL : (implicitsResolver = (g_object_unref (implicitsResolver), NULL)));
				return;
			}
			code_generator = gtkaml_code_generator_new (self->priv->context);
			gtkaml_code_generator_generate (code_generator, GTKAML_CLASS_DEFINITION (root_class_definition));
			if (vala_report_get_errors () != 0) {
				(dummy_file == NULL ? NULL : (dummy_file = (g_object_unref (dummy_file), NULL)));
				(sax_parser == NULL ? NULL : (sax_parser = (g_object_unref (sax_parser), NULL)));
				(root_class_definition == NULL ? NULL : (root_class_definition = (g_object_unref (root_class_definition), NULL)));
				(implicitsResolver == NULL ? NULL : (implicitsResolver = (g_object_unref (implicitsResolver), NULL)));
				(code_generator == NULL ? NULL : (code_generator = (g_object_unref (code_generator), NULL)));
				return;
			}
			vala_contents = gtkaml_code_generator_yield (code_generator);
			if (vala_contents != NULL) {
				char* _tmp0;
				char* _tmp1;
				char* vala_filename;
				_tmp0 = NULL;
				_tmp1 = NULL;
				vala_filename = (_tmp1 = g_strconcat ((_tmp0 = g_strndup (vala_source_file_get_filename (gtkaml_source_file), ((gulong) (g_utf8_strlen (vala_source_file_get_filename (gtkaml_source_file), -1) - g_utf8_strlen (".gtkaml", -1))))), ".vala", NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
				g_file_set_contents (vala_filename, vala_contents, -1, &inner_error);
				if (inner_error != NULL) {
					if (inner_error->domain == G_FILE_ERROR) {
						goto __catch3_g_file_error;
					}
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
				}
				vala_source_file_set_filename (gtkaml_source_file, vala_filename);
				VALA_CODE_VISITOR_CLASS (gtkaml_parser_parent_class)->visit_source_file (VALA_CODE_VISITOR (VALA_PARSER (self)), gtkaml_source_file);
				if (vala_report_get_errors () == 0 && !vala_code_context_get_save_temps (self->priv->context)) {
					g_unlink (vala_filename);
				}
				vala_filename = (g_free (vala_filename), NULL);
			}
			(dummy_file == NULL ? NULL : (dummy_file = (g_object_unref (dummy_file), NULL)));
			(sax_parser == NULL ? NULL : (sax_parser = (g_object_unref (sax_parser), NULL)));
			(root_class_definition == NULL ? NULL : (root_class_definition = (g_object_unref (root_class_definition), NULL)));
			(implicitsResolver == NULL ? NULL : (implicitsResolver = (g_object_unref (implicitsResolver), NULL)));
			(code_generator == NULL ? NULL : (code_generator = (g_object_unref (code_generator), NULL)));
			vala_contents = (g_free (vala_contents), NULL);
		}
		goto __finally3;
		__catch3_g_file_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				vala_report_error (NULL, e->message);
				(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
			}
		}
		__finally3:
		;
	} else {
		char* _tmp2;
		_tmp2 = NULL;
		vala_report_error (NULL, (_tmp2 = g_strdup_printf ("%s not found", vala_source_file_get_filename (gtkaml_source_file))));
		_tmp2 = (g_free (_tmp2), NULL);
	}
}


void gtkaml_parser_parse_gtkaml_file (GtkamlParser* self, ValaSourceFile* gtkaml_source_file) {
	GTKAML_PARSER_GET_CLASS (self)->parse_gtkaml_file (self, gtkaml_source_file);
}


static void gtkaml_parser_class_init (GtkamlParserClass * klass) {
	gtkaml_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlParserPrivate));
	G_OBJECT_CLASS (klass)->finalize = gtkaml_parser_finalize;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = gtkaml_parser_real_visit_source_file;
	GTKAML_PARSER_CLASS (klass)->parse_gtkaml_file = gtkaml_parser_real_parse_gtkaml_file;
}


static void gtkaml_parser_instance_init (GtkamlParser * self) {
	self->priv = GTKAML_PARSER_GET_PRIVATE (self);
	self->priv->implicits_store = gtkaml_implicits_store_new ();
}


static void gtkaml_parser_finalize (GObject * obj) {
	GtkamlParser * self;
	self = GTKAML_PARSER (obj);
	(self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL)));
	(self->priv->current_source_file == NULL ? NULL : (self->priv->current_source_file = (g_object_unref (self->priv->current_source_file), NULL)));
	(self->priv->implicits_store == NULL ? NULL : (self->priv->implicits_store = (g_object_unref (self->priv->implicits_store), NULL)));
	G_OBJECT_CLASS (gtkaml_parser_parent_class)->finalize (obj);
}


GType gtkaml_parser_get_type (void) {
	static GType gtkaml_parser_type_id = 0;
	if (gtkaml_parser_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlParser), 0, (GInstanceInitFunc) gtkaml_parser_instance_init };
		gtkaml_parser_type_id = g_type_register_static (VALA_TYPE_PARSER, "GtkamlParser", &g_define_type_info, 0);
	}
	return gtkaml_parser_type_id;
}




