#include <stdio.h>
#include <libnd.h>

int
main(int argn, char **argv)
{
  LND_Trace          *trace;
  LND_PacketIterator  pit;
  char line[4096];

  if (argn < 2)
    {
      printf("USAGE: lnd-tcpdump <trace file>\n"
	     "lnd-tcpdump is a tcpdump wrapper implemented using libnetdude.\n"
	     "It shows tcpdump output per packet, per libnetdude's configuration.\n");
      exit(-1);
    }

  libnd_init();

  /* Open a tracefile: */
  if (! (trace = libnd_trace_new(argv[1])))
    {
      printf("Could not open %s\n", argv[1]);
      exit(-1);
    }
        
  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      libnd_tcpdump_get_packet_line(libnd_pit_get(&pit), line, 4096, FALSE);
      printf("%s\n", line);
    }

  return 0;
}

        


