/* Copyright (C) 2006-2007 G.P. Halkes
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 3, as
   published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* #define LEAVE_FILES */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "definitions.h"

static TempFile files[4];
static int openIndex = 0;

#ifndef LEAVE_FILES
static bool inited;

/** Remove up all the created files. */
static void cleanup(void) {
	int i;
	for (i = 0; i < openIndex; i++) {
		fclose(files[i].file);
		remove(files[i].name);
	}
}
#endif

/** Create a temporary file. */
TempFile *tempFile(void) {
#ifdef LEAVE_FILES
	/* In case we are testing and want to see the temporary files,
	   we use these names. */
	static const char *names[4] = { "oldTokens", "oldWhitespace", "newTokens", "newWhitespace" };

	strcpy(files[openIndex].name, names[openIndex]);
	if ((files[openIndex].file = fopen(files[openIndex].name, "w+")) == NULL)
		return NULL;
#else
	/* Create temporary file. */
	int fd;
	
	if (!inited) {
		/* Make sure the umask is set so that we don't introduce a security risk. */
		umask(~S_IRWXU);
		/* Make sure we will remove temporary files on exit. */
		atexit(cleanup);
		inited = true;
	}

	strcpy(files[openIndex].name, TEMPLATE);
	if ((fd = mkstemp(files[openIndex].name)) < 0)
		return NULL;
	if ((files[openIndex].file = fdopen(fd, "r+")) == NULL)
		return NULL;
#endif	
	return files + openIndex++;
}
