/* Bluefish HTML Editor
 * interface.h - interface stuff
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Changes by Antti-Juhani Kaijanaho <gaia@iki.fi> on 1999-10-20  */

#ifndef __INTERFACE_H_
#define __INTERFACE_H_

/* statusbar message times 
 * the time to use (using these defines)
 * 3000 for a normal message
 * 6000 for a warning message
 * 12000 for a bug, severe error, critical situations etc.
 */
#define NORMAL_MESSAGE 3000
#define IMPORTANT_MESSAGE 6000
#define CRITICAL_MESSAGE 12000

/* the handle boxes where the toolbars can be added to 
   they are packed in the right place in interface.c, the 
   menubars are added in toolbars.c */

void toggle_main_toolbar_cb(GtkWidget * w, gpointer data);
void toggle_html_toolbar_cb(GtkWidget * w, gpointer data);
void toggle_cust_menubar_cb(GtkWidget * w, gpointer data);
void file_and_dir_history_add(gchar *filename);
void file_and_dir_history_remove(gchar *filename);
void statusbar_message(gpointer message, gint time);
gint statusbar_remove(gpointer message_id);
gint bf_statusbar_message(gpointer message);
void notebook_next_document_cb(GtkWidget *widget, gpointer data);
void notebook_prev_document_cb(GtkWidget *widget, gpointer data);
gboolean switch_to_document_by_pointer(Tdocument *document);
gboolean switch_to_document_by_filename(gchar *filename);
void notebook_changed(void);
void notebook_set_tab_pos(gchar * position);
void filelist_set_size();
void startup(void);
void show_about_window_cb(GtkWidget * w, gpointer data);
void dndwin_cb (GtkWidget * widget, gpointer data);
void populate_dir_file_list(void);
void populate_dir_history(void);


#endif							/* __INTERFACE_H_ */
