/* Bluefish HTML Editor
 * configure_cb.c
 *
 * Copyright (C) 1999 Olivier Sessink
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "default_include.h"

#include <string.h>
#include <locale.h>
#include <ctype.h> 	/* isspace() */

#include "bluefish.h"
#include "bf_lib.h"
#include "init.h"
#include "gtk_easy.h"
#include "menu.h"
#include "interface.h"
#include "highlight.h"
#include "document.h"			/* set fonts */

typedef enum { none, file, font } Textra_but;

static GtkWidget *font_e, *browser_e, *weblint_e, *tabfont_e, *tabpos_c;
static GtkWidget *width_s, *height_s, *tab_s, *thumbtype_c, *thumbstring_e, *max_recent_s, *max_dir_his_s, *filelist_filter_c;
static GtkWidget *full_li_c, *full_p_c, *lowercase_tags_c, *word_wrap_c, *autoindent_c , *line_wrap_c, *fontset_c, *link_management_c, *defaulthighlight_c, *conv_shift_enter_c, *conv_ctrl_enter_c, *shift_enter_text_c, *ctrl_enter_text_c, *conv_special_char_c;
static GtkWidget *cont_high_up_c, *cont_highlight_full_c, *allow_css_c, *html_ver_c, *allow_dep_c, *xhtml_c, *allow_ruby_c, *allow_frames_c, *force_dtd_c, *dtd_url_c, *allow_h4_c, *xml_start_c;
static GtkWidget *backup_filestring_e, *backup_file_c, *allow_multi_instances_c;
static GtkWidget *file_width_s, *force_def_style_c, *drop_at_drop_pos_c;
static GtkWidget *filebrowser_filter_image_e, *filebrowser_filter_php_e, *filebrowser_filter_html_e, *filebrowser_filter_jscript_e, *filebrowser_filter_css_e, *filebrowser_filter_other_e;
static GtkWidget *format_by_context_c, *transient_htdialogs_c;
#ifdef WITH_MSG_QUEUE
static GtkWidget *open_in_running_bluefish_c;
#endif
#ifdef WITH_SPC
static GtkWidget *spc_command_e, *spc_lang_e, *spc_acc_comp_c, *spc_use_esc_c,
          *spc_use_pers_dict_c, *spc_pers_dict_e, *spc_use_input_encoding_c,
          *spc_input_encoding_e,*spc_output_html_chars_c;
#endif

/**************************************************************************/
void configure_cb(GtkWidget * widget, gpointer data);
static GtkWidget *combo_entry2(gchar * labeltext, gchar * which_config_string, GtkWidget * box, GList * poplist);
static GtkWidget *check_entry2(gchar * labeltext, gint which_config_int, GtkWidget * box);
static void apply_choose_font(GtkWidget * widget, gpointer data);
static void ok_choose_font(GtkWidget * widget, gpointer data);
static void delete_choose_font(GtkWidget * widget, GdkEventAny * event, gpointer data);
static void close_choose_font(GtkWidget * widget, gpointer data);
static void choose_font(GtkWidget * widget, gpointer data);
static void integer_apply(gint * config_var, GtkWidget * spinbutton);
static void check_apply(gint * config_var, GtkWidget * check_button);

/**************************************************************************/

/*************************
 * 
 * start of functions
 *
 *************************/

static GtkWidget *string_entry2(gchar * labeltext, gchar * which_config_string, GtkWidget * box, Textra_but with_but)
{
	GtkWidget *hbox, *return_widget, *font_b=NULL;

	hbox = gtk_hbox_new(FALSE,3);
	gtk_box_pack_start(GTK_BOX(hbox), gtk_label_new(labeltext), FALSE, FALSE, 3);
	return_widget = boxed_entry_with_text(which_config_string, 1023, hbox);
	gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 3);
	if (with_but == file) {
		gtk_box_pack_start(GTK_BOX(hbox), file_but_new(return_widget, gtk_widget_get_toplevel(box), 1), FALSE, FALSE, 3);
	} else if (with_but == font) {
		font_b = gtk_button_new_with_label(_("Font..."));
		gtk_signal_connect(GTK_OBJECT(font_b), "clicked", GTK_SIGNAL_FUNC(choose_font), return_widget);
		gtk_box_pack_start(GTK_BOX(hbox), font_b, FALSE, FALSE, 0);
	}
	return return_widget;
}

static GtkWidget *combo_entry2(gchar * labeltext, gchar * which_config_string, GtkWidget * box, GList * poplist)
{
	GtkWidget *return_widget;
	GtkWidget *hbox;

	hbox = gtk_hbox_new(FALSE,3);
	gtk_box_pack_start(GTK_BOX(hbox), gtk_label_new(labeltext), FALSE, FALSE, 3);
	return_widget = boxed_combo_with_popdown(which_config_string, poplist, 0, hbox);
	gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 3);
	return return_widget;
}

static GtkWidget *check_entry2(gchar * labeltext, gint which_config_int, GtkWidget * box)
{
	return boxed_checkbut_with_value(labeltext, which_config_int, box);
}

static GtkWidget *spin_button2(gchar *labeltext, gint which_config_int, GtkWidget * box, gfloat lower, gfloat upper) {
	GtkWidget *return_widget;
	GtkWidget *hbox;
	GtkObject *adjust;
	gfloat step_increment, page_increment;

	step_increment = (upper - lower)/1000;
	if (step_increment < 1) {
		step_increment = 1;
	}
	page_increment = (upper - lower)/20;
	if (page_increment < 10) {
		page_increment = 10;
	}
	hbox = gtk_hbox_new(FALSE,3);
	adjust = gtk_adjustment_new((1.0 * which_config_int), lower, upper, step_increment ,page_increment , 0);
	return_widget = gtk_spin_button_new(GTK_ADJUSTMENT(adjust), 0.1, 0);
	gtk_box_pack_start(GTK_BOX(hbox), gtk_label_new(labeltext), FALSE, FALSE, 3);
	gtk_box_pack_start(GTK_BOX(hbox), return_widget, TRUE, TRUE, 3);
	gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 3);
	return return_widget;
}

/*
 */
static void apply_choose_font(GtkWidget * widget, gpointer data)
{
	gchar *font;
	GtkWidget *font_dialog;

	font_dialog = gtk_widget_get_toplevel(widget);
	font = gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(font_dialog));
	DEBUG_MSG("apply_choose_font, font=%s\n", font);
	gtk_entry_set_text(GTK_ENTRY(data), font);
};

/*
 */
static void ok_choose_font(GtkWidget * widget, gpointer data)
{
	apply_choose_font(widget, data);
	delete_choose_font(widget, NULL, data);
};

/*
 */
static void delete_choose_font(GtkWidget * widget, GdkEventAny * event, gpointer data)
{
	GtkWidget *win;
	DEBUG_MSG("delete_choose_font, data=%p\n", data);
	win = gtk_widget_get_toplevel(widget);
	gtk_grab_remove(GTK_WIDGET(win));
	gtk_widget_destroy(GTK_WIDGET(win));
};

/*
 */
static void close_choose_font(GtkWidget * widget, gpointer data)
{
	delete_choose_font(widget, NULL, data);
};

/*
 * Function: choose_font
 * Arguments:
 * 	widget	- called widget
 * 	data	- pointer to entry widget
 * Return value:
 * 	void
 * Desciption:
 * 	Callback function for calling GtkFontSelection and install
 * 	choosed font string in entry 8-)
 */
static void choose_font(GtkWidget * widget, gpointer data)
{
	GtkWidget *font_dialog;
	gchar *font;

	font_dialog = gtk_font_selection_dialog_new(_("Font Selection"));

	/* Set font in font selection dialog */
	font = gtk_editable_get_chars(GTK_EDITABLE(data), 0, -1);
	gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(font_dialog), font);
	g_free(font);

	/* connect all needing signals */
	gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(font_dialog)->ok_button),
					   "clicked", GTK_SIGNAL_FUNC(ok_choose_font), (gpointer) data);

	gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(font_dialog)->apply_button),
					   "clicked", GTK_SIGNAL_FUNC(apply_choose_font), (gpointer) data);

	gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(font_dialog)->cancel_button),
					   "clicked", GTK_SIGNAL_FUNC(close_choose_font), (gpointer) data);

	gtk_signal_connect(GTK_OBJECT(font_dialog), "delete_event", GTK_SIGNAL_FUNC(delete_choose_font), (gpointer) data);

	DEBUG_MSG("font_dialog=%p\n", font_dialog);
	gtk_widget_show_all(font_dialog);

	/* make modal */
	gtk_grab_add(font_dialog);
};


static void save_n_apply_config()
{
	GList *tmplist;
	Tdocument *tmpdoc;

	save_config_files();
	
	/* actually try to apply these config values */
	gtk_window_set_policy(GTK_WINDOW(main_v->main_window), FALSE, FALSE, FALSE);
	gtk_widget_set_usize(GTK_WIDGET(main_v->main_window), main_v->props.main_window_w, main_v->props.main_window_h);
	gtk_window_set_policy(GTK_WINDOW(main_v->main_window), TRUE, TRUE, FALSE);
	tmplist = g_list_first(main_v->documentlist);
	while (tmplist) {
		tmpdoc = (Tdocument *) tmplist->data;
		if (tmpdoc) {
			document_set_fonts(main_v->props.cfg_editor_font, main_v->props.cfg_tab_font, tmpdoc);
			document_set_wrap(main_v->props.word_wrap, main_v->props.line_wrap, tmpdoc);
			document_force_def_style(tmpdoc, main_v->props.force_def_style);

			GTK_TEXT(tmpdoc->textbox)->default_tab_width = main_v->props.cfg_editor_tabwidth;
		}						/* if (tmpdoc) */
		tmplist = g_list_next(tmplist);
	}
	notebook_set_tab_pos(main_v->props.cfg_tab_pos);
	filelist_set_size();
	load_identify_filters();
	make_syntax_struct_list();
	make_external_menu_entries(1);
	make_external_menu_entries(2);

	statusbar_message(_("Configuration saved and applied succesfully"), 1000);
	DEBUG_MSG("apply_config, finished applying config values\n");
}

static void unescape_string_apply(gchar ** config_var, GtkWidget * entry) {
	gchar *tmp;

	tmp = NULL;
	string_apply(&tmp, entry);
	if (tmp) {
		g_free(*config_var);
		*config_var = unescapestring(tmp);
		g_free(tmp);
	}
}

static void configure_ok_lcb(GtkWidget * button, gpointer entry) {
	statusbar_message(_("Saving and applying configuration"), 1000);
	string_apply(&main_v->props.cfg_browser_cline, browser_e);
	string_apply(&main_v->props.cfg_weblint_cline, weblint_e);
	string_apply(&main_v->props.cfg_editor_font, font_e);
	string_apply(&main_v->props.cfg_tab_font, tabfont_e);
	string_apply(&main_v->props.cfg_tab_pos, GTK_COMBO(tabpos_c)->entry);
	string_apply(&main_v->props.cfg_thumbnailtype, GTK_COMBO(thumbtype_c)->entry);
	string_apply(&main_v->props.cfg_thumbnailstring, thumbstring_e);
	integer_apply(&main_v->props.main_window_w, width_s);
	integer_apply(&main_v->props.main_window_h, height_s);
	integer_apply(&main_v->props.main_filelist_size, file_width_s);
	integer_apply(&main_v->props.cfg_editor_tabwidth, tab_s);
	integer_apply(&main_v->props.max_recent_files, max_recent_s);
	integer_apply(&main_v->props.max_dir_history, max_dir_his_s);
	string_apply(&main_v->props.filelist_filter, GTK_COMBO(filelist_filter_c)->entry);
	string_apply(&main_v->props.filebrowser_filter_image, filebrowser_filter_image_e);
	string_apply(&main_v->props.filebrowser_filter_php, filebrowser_filter_php_e);
	string_apply(&main_v->props.filebrowser_filter_html, filebrowser_filter_html_e);
	string_apply(&main_v->props.filebrowser_filter_jscript, filebrowser_filter_jscript_e);
	string_apply(&main_v->props.filebrowser_filter_css, filebrowser_filter_css_e);
	string_apply(&main_v->props.filebrowser_filter_other, filebrowser_filter_other_e);
	check_apply(&main_v->props.transient_htdialogs, transient_htdialogs_c);
	check_apply(&main_v->props.full_p, full_p_c);
	check_apply(&main_v->props.full_li, full_li_c);
	check_apply(&main_v->props.allow_css, allow_css_c);
	check_apply(&main_v->props.format_by_context, format_by_context_c);
	check_apply(&main_v->props.allow_dep, allow_dep_c);
	check_apply(&main_v->props.xhtml, xhtml_c);
	check_apply(&main_v->props.allow_ruby, allow_ruby_c);
	check_apply(&main_v->props.allow_h4, allow_h4_c);
	check_apply(&main_v->props.allow_frames, allow_frames_c);
	check_apply(&main_v->props.force_dtd, force_dtd_c);
	check_apply(&main_v->props.dtd_url, dtd_url_c);
	check_apply(&main_v->props.xml_start, xml_start_c);
	check_apply(&main_v->props.word_wrap, word_wrap_c);
	check_apply(&main_v->props.autoindent, autoindent_c);
	check_apply(&main_v->props.line_wrap, line_wrap_c);
	check_apply(&main_v->props.fontset, fontset_c);
	check_apply(&main_v->props.force_def_style, force_def_style_c);
	check_apply(&main_v->props.drop_at_drop_pos, drop_at_drop_pos_c);
	check_apply(&main_v->props.link_management, link_management_c);
	check_apply(&main_v->props.allow_multi_instances, allow_multi_instances_c);
	check_apply(&main_v->props.defaulthighlight, defaulthighlight_c);
	check_apply(&main_v->props.lowercase_tags, lowercase_tags_c);
	check_apply(&main_v->props.cont_highlight_update, cont_high_up_c);
	check_apply(&main_v->props.cont_highlight_full, cont_highlight_full_c);
	string_apply(&main_v->props.html_ver, GTK_COMBO(html_ver_c)->entry);
#ifdef WITH_SPC
	string_apply(&main_v->props.cfg_spc_cline, spc_command_e);
	string_apply(&main_v->props.cfg_spc_lang, spc_lang_e);
	check_apply(&main_v->props.spc_accept_compound, spc_acc_comp_c);
	check_apply(&main_v->props.spc_use_esc_chars, spc_use_esc_c);
	check_apply(&main_v->props.spc_use_pers_dict, spc_use_pers_dict_c);
	string_apply(&main_v->props.spc_pers_dict, spc_pers_dict_e);
   check_apply(&main_v->props.spc_use_input_encoding, spc_use_input_encoding_c);
	string_apply(&main_v->props.spc_input_encoding, spc_input_encoding_e);
   check_apply(&main_v->props.spc_output_html_chars, spc_output_html_chars_c);
#endif
	string_apply(&main_v->props.backup_filestring, backup_filestring_e);
   check_apply(&main_v->props.backup_file, backup_file_c);
#ifdef WITH_MSG_QUEUE
	check_apply(&main_v->props.open_in_running_bluefish, open_in_running_bluefish_c);
#endif
	check_apply(&main_v->props.conv_shift_enter, conv_shift_enter_c);
	check_apply(&main_v->props.conv_ctrl_enter, conv_ctrl_enter_c);
	check_apply(&main_v->props.conv_special_char, conv_special_char_c);

	unescape_string_apply(&main_v->props.shift_enter_text, shift_enter_text_c);
	unescape_string_apply(&main_v->props.ctrl_enter_text, ctrl_enter_text_c);

	if (main_v->props.syntax_configstrings == NULL) {
		reset_syntax_highlighting_lcb(NULL, NULL);
	}
	gtk_main_quit();

	save_n_apply_config();
}

void configure_cb(GtkWidget * widget, gpointer page)
/* page: which page of the configuration notebook to show */
{
	GtkWidget *frame, *dialog;
	GtkWidget *ok;
	GtkWidget *cancel;
	GtkWidget *vbox, *tmpvbox, *dvbox, *ahbox;
	GtkWidget *hbox, *vbox1, *vbox2;
	GtkWidget *notebook;
	GList *poplist = NULL;
	gint count;
	gchar *tmpstr;

	/* create the widgets */
	DEBUG_MSG("configure_cb, started\n");
	count = bf_statusbar_message(_("Configuration Window"));
	dialog = window_with_title(_("Bluefish: configure"), GTK_WIN_POS_NONE, GTK_WINDOW_DIALOG, 5);
	gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_signal_connect(GTK_OBJECT(dialog), "destroy", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

	gtk_widget_realize(dialog);
	
	dvbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(dialog), dvbox);

	notebook = gtk_notebook_new();
	gtk_notebook_set_homogeneous_tabs(GTK_NOTEBOOK(notebook), TRUE);
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_BOTTOM);
	gtk_box_pack_start(GTK_BOX(dvbox), notebook, TRUE, TRUE, 7);

	/* editor */
	frame = gtk_frame_new(_("Editor options"));
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	font_e = string_entry2(_("Default font"), main_v->props.cfg_editor_font, vbox, font);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(vbox), hbox);
	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(hbox), vbox1);	/*left*/
	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(hbox), vbox2);	/*right*/

	/*vbox1*/
	force_def_style_c = check_entry2(_("Force white editor background"), main_v->props.force_def_style, vbox1);
	tab_s = spin_button2(_("Tab width"), main_v->props.cfg_editor_tabwidth, vbox1, 1.0, 20.0);
	word_wrap_c = check_entry2(_("Word wrap"), main_v->props.word_wrap, vbox1);
	line_wrap_c = check_entry2(_("Line wrap"), main_v->props.line_wrap, vbox1);
	autoindent_c = check_entry2(_("Autoindent Code"), main_v->props.autoindent, vbox1);
	defaulthighlight_c = check_entry2(_("Highlight by default"), main_v->props.defaulthighlight, vbox1);
	cont_high_up_c = check_entry2(_("Update syntax highlighting continuous"), main_v->props.cont_highlight_update, vbox1);
	cont_highlight_full_c = check_entry2(_("Update full widget instead of the current line (slower)"), main_v->props.cont_highlight_full, vbox1);
	link_management_c = check_entry2(_("Automatic link management"), main_v->props.link_management, vbox1);

	drop_at_drop_pos_c = check_entry2(_("Insert drag and drop at drop position\ninstead of cursor position (experimental)"), main_v->props.drop_at_drop_pos, vbox1);

	/*vbox2*/
	conv_shift_enter_c = check_entry2(_("Insert text with Shift-Enter"), main_v->props.conv_shift_enter, vbox2);
	tmpstr = escapestring(main_v->props.shift_enter_text, 0);
	if (tmpstr)
		shift_enter_text_c = string_entry2("  ", tmpstr, vbox2, none);
	g_free(tmpstr);
	conv_ctrl_enter_c = check_entry2(_("Insert text with Ctrl-Enter"), main_v->props.conv_ctrl_enter, vbox2);
	tmpstr = escapestring(main_v->props.ctrl_enter_text, 0);
	if (tmpstr)
		ctrl_enter_text_c = string_entry2("  ", tmpstr, vbox2, none);
	g_free(tmpstr);
	conv_special_char_c = check_entry2(_("Insert HTML entity with Ctrl-(special char)\n(&lt; &gt; &amp;)"), main_v->props.conv_special_char, vbox2);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, gtk_label_new(_("Editor")));

	/* HTML options */
	frame = gtk_frame_new(_("HTML options"));
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	/* should set the following vars, if required also disables */
	poplist = NULL;
	poplist = g_list_append(poplist, "HTML 3.2");
	poplist = g_list_append(poplist, "HTML 4.0 Strict");
	poplist = g_list_append(poplist, "HTML 4.0 Transitional");
	poplist = g_list_append(poplist, "XHTML 1.0 Strict");
	poplist = g_list_append(poplist, "XHTML 1.0 Transitional");
	poplist = g_list_append(poplist, "XHTML Basic");
	poplist = g_list_append(poplist, "XHTML 1.1");
	poplist = g_list_append(poplist, "allow everything");
	poplist = g_list_append(poplist, "Read from File");
	html_ver_c = combo_entry2(_("used HTML-Version"), main_v->props.html_ver, vbox, poplist);
	g_list_free(poplist);

	/* Teachers will love these many options *g* */
	full_li_c = check_entry2(_("Insert closing lists </LI>, </DT>, </DD>"), main_v->props.full_li, vbox);
	full_p_c = check_entry2(_("Insert closing paragraph tag </P>"), main_v->props.full_p, vbox);
	lowercase_tags_c = check_entry2(_("Insert lowercase HTML tags (Needed for WML!)"), main_v->props.lowercase_tags, vbox);
	allow_css_c = check_entry2(_("Allow the use of CSS"), main_v->props.allow_css, vbox);
	allow_dep_c = check_entry2(_("Allow deprecated tags (like <FONT>)"), main_v->props.allow_dep, vbox);
	format_by_context_c = check_entry2(_("Format by context (e.g. <strong> instead of <b>)"), main_v->props.format_by_context, vbox);
	xhtml_c = check_entry2(_("Use XHTML syntax (like <br />)"), main_v->props.xhtml, vbox);
	xml_start_c = check_entry2(_("Use an XML-Starting-Line"), main_v->props.xml_start, vbox);
	allow_ruby_c = check_entry2(_("Allow the Ruby-Tags included in XHTML 1.0"), main_v->props.allow_ruby, vbox);
	allow_h4_c = check_entry2(_("Allow new tags of HTML 4.0"), main_v->props.allow_h4, vbox);
	allow_frames_c = check_entry2(_("Allow the use of frames"), main_v->props.allow_frames, vbox);
	force_dtd_c = check_entry2(_("Require an DOCTYPE on first line of document"), main_v->props.force_dtd, vbox);
	dtd_url_c = check_entry2(_("Set the DTD-URL in the DOCTYPE line"), main_v->props.dtd_url, vbox);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, gtk_label_new(_("HTML")));

	/* main GUI */
	frame = gtk_frame_new(_("Main GUI options"));
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	tabfont_e = string_entry2(_("Notebook tab fontset"), main_v->props.cfg_tab_font, vbox, font);
	fontset_c = check_entry2(_("Font is a fontset"), main_v->props.fontset, vbox);

	poplist = NULL;
	poplist = g_list_append(poplist, "top");
	poplist = g_list_append(poplist, "bottom");
	poplist = g_list_append(poplist, "left");
	poplist = g_list_append(poplist, "right");

	tabpos_c = combo_entry2(_("Notebook position"), main_v->props.cfg_tab_pos, vbox, poplist);
	g_list_free(poplist);

	width_s = spin_button2(_("Initial width"), main_v->props.main_window_w, vbox, 50.0, 2000.0);
	height_s = spin_button2(_("Initial height"), main_v->props.main_window_h, vbox, 50.0, 2000.0);

	max_recent_s = spin_button2(_("Items in Open Recent menu"), main_v->props.max_recent_files, vbox, 1, 40);
	max_dir_his_s = spin_button2(_("Items in Directory history"), main_v->props.max_dir_history, vbox, 1, 40);

	file_width_s = spin_button2(_("File browser mininum size"), main_v->props.main_filelist_size, vbox, 10.0, 1000.0);

	poplist = NULL;
	poplist = g_list_append(poplist, _("all files"));
	poplist = g_list_append(poplist, _("all web files"));
	poplist = g_list_append(poplist, _("images"));
	poplist = g_list_append(poplist, _("documents"));
	filelist_filter_c = combo_entry2(_("File browser default filter"), main_v->props.filelist_filter, vbox, poplist);
	g_list_free(poplist);

	transient_htdialogs_c = check_entry2(_("Keep HTML dialogs on top"), main_v->props.transient_htdialogs, vbox);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, gtk_label_new(_("GUI")));

	/* image dialog */
	tmpvbox = gtk_vbox_new(FALSE, 0);
	frame = gtk_frame_new(_("Files and images"));
	gtk_box_pack_start(GTK_BOX(tmpvbox), frame, FALSE, FALSE, 0);
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	poplist = NULL;
	poplist = g_list_append(poplist, "png");
	poplist = g_list_append(poplist, "jpg");
	poplist = g_list_append(poplist, "gif");
	thumbtype_c = combo_entry2(_("Thumbnail type"), main_v->props.cfg_thumbnailtype, vbox, poplist);
	g_list_free(poplist);

	thumbstring_e = string_entry2(_("Thumbnail extension string"), main_v->props.cfg_thumbnailstring, vbox, none);

	allow_multi_instances_c = check_entry2(_("Allow multiple instances of the same file"), main_v->props.allow_multi_instances, vbox);
	backup_file_c = check_entry2(_("Backup file before saving"), main_v->props.backup_file, vbox);
	backup_filestring_e = string_entry2(_("Backup file suffix"), main_v->props.backup_filestring, vbox, none);
#ifdef WITH_MSG_QUEUE
	open_in_running_bluefish_c = check_entry2(_("Open commandline files in already running bluefish"), main_v->props.open_in_running_bluefish, vbox);
#endif
	frame = gtk_frame_new(_("File filters"));
	gtk_box_pack_start(GTK_BOX(tmpvbox), frame, FALSE, FALSE, 0);
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	filebrowser_filter_image_e = string_entry2(_("Image filter"), main_v->props.filebrowser_filter_image, vbox, none);
	filebrowser_filter_php_e = string_entry2(_("PHP filter"), main_v->props.filebrowser_filter_php, vbox, none);
	filebrowser_filter_html_e = string_entry2(_("HTML filter"), main_v->props.filebrowser_filter_html, vbox, none);
	filebrowser_filter_jscript_e = string_entry2(_("JavaScript filter"), main_v->props.filebrowser_filter_jscript, vbox, none);
	filebrowser_filter_css_e = string_entry2(_("Cascading stylesheet filter"), main_v->props.filebrowser_filter_css, vbox, none);
	filebrowser_filter_other_e = string_entry2(_("Other webfiles filter"), main_v->props.filebrowser_filter_other, vbox, none);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tmpvbox, gtk_label_new(_("Files and images")));

	/* external programs */

	tmpvbox = gtk_vbox_new(FALSE, 0);
	frame = gtk_frame_new(_("External program options"));
	gtk_box_pack_start(GTK_BOX(tmpvbox), frame, FALSE, FALSE, 0);
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	browser_e = string_entry2(_("Browser command"), main_v->props.cfg_browser_cline, vbox, file);
	weblint_e = string_entry2(_("Weblint command"), main_v->props.cfg_weblint_cline, vbox, file);

#ifdef WITH_SPC
	frame = gtk_frame_new(_("Spell checker options"));
	gtk_box_pack_start(GTK_BOX(tmpvbox), frame, FALSE, FALSE, 0);
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	spc_command_e = string_entry2(_("Ispell command"), main_v->props.cfg_spc_cline, vbox,1 );
	spc_lang_e = string_entry2(_("Default language"), main_v->props.cfg_spc_lang, vbox, 0);
	spc_acc_comp_c = check_entry2(_("Accept compound words"), main_v->props.spc_accept_compound, vbox);
	spc_use_esc_c = check_entry2(_("Specify additional characters that might form a word"), main_v->props.spc_use_esc_chars, vbox);
	spc_use_pers_dict_c = check_entry2(_("Use personal dictionary"), main_v->props.spc_use_pers_dict, vbox);
	spc_pers_dict_e = string_entry2(_("Personal dictionary"), main_v->props.spc_pers_dict, vbox, 1);
   spc_use_input_encoding_c = check_entry2(_("Use input encoding"), main_v->props.spc_use_input_encoding, vbox);
	spc_input_encoding_e = string_entry2(_("Input Encoding"), main_v->props.spc_input_encoding, vbox, 0);
   spc_output_html_chars_c = check_entry2(_("Output html characters"), main_v->props.spc_output_html_chars, vbox);
#endif

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tmpvbox, gtk_label_new(_("External")));

	ahbox = gtk_hbutton_box_new();
	gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(ahbox), 1);

	gtk_box_pack_start(GTK_BOX(dvbox), ahbox, FALSE, FALSE, 0);
	ok = bf_stock_button(_(" Save & close "), GTK_SIGNAL_FUNC(configure_ok_lcb), dialog);
	cancel = bf_stock_cancel_button(GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_window_set_default(GTK_WINDOW(dialog), ok);
	/* pack the widgets */
	gtk_box_pack_start(GTK_BOX(ahbox), ok, TRUE, TRUE, 0);
	gtk_box_pack_end(GTK_BOX(ahbox), cancel, TRUE, TRUE, 0);

	/* show the widgets */
	DEBUG_MSG("Opening page %i \n",GPOINTER_TO_INT(page));
        gtk_notebook_set_page (GTK_NOTEBOOK(notebook),GPOINTER_TO_INT(page));
	gtk_widget_show_all(dialog);
	gtk_grab_add(dialog);
	
	gtk_main();
	DEBUG_MSG("configure_cb, just after gtk_main()\n");
  	statusbar_remove(GINT_TO_POINTER(count));
	window_destroy(dialog);
}

static void integer_apply(gint * config_var, GtkWidget * spinbutton)
{

	*config_var = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinbutton));
}

static void check_apply(gint * config_var, GtkWidget * check_button)
{

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button))) {
		*config_var = 1;
	} else {
		*config_var = 0;
	}
}

