/* Bluefish HTML Editor
 * callbacks.c - contains all callbacks
 *
 * Copyright (C) 1998-1999 Olivier Sessink and Chris Mazuc
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "default_include.h"

#include <locale.h>

#include <stdlib.h>				/* system() */
#include <gdk/gdkkeysyms.h>		/* GDK_Escape */
#include <stdio.h>				/* FILE */
#include <unistd.h>				/* close() */
#include <string.h>				/* strchr() */
#include <sys/stat.h>			/* struct stat */

#ifdef WITH_INTERNAL_PREVIEW
#include <gtk-xmhtml/gtk-xmhtml.h>
#endif

#include "bluefish.h"
#include "bf_lib.h"
#include "callbacks.h"
#include "network.h"
#include "document.h"			/* doc_textbox_to_file */
#include "interface.h"			/* statusbar */
#include "stringlist.h"			/* add_to_stringlist() */
#include "gtk_easy.h"			/* error_dialog() */

/* these should use the proper .h files instead of using them extern */
/* again extern ? TRY TO AVOID EXTERN DEFINITIONS IN .C FILES!!!!
USE #INCLUDE STATEMENTS INSTEAD!!!
 */
extern int closed;
extern int sockfd;


/* this struct is used for the closing of modified files */
typedef struct {
	GtkWidget *dialog;
	gint still_continue;
} Warn_Close_Struct;


/****************************************************************/

/* view in netscape functions */

void view_in_netscape_cb(GtkWidget * widget, gpointer data)
{
	gchar *command;
	gint rcode;
	gchar *url, *url2;


	if (main_v->current_document->filename == NULL) {
		file_save_as_cb(widget, data);
		if (main_v->current_document->filename == NULL) {
			return;
		}
	} else if (main_v->current_document->modified == 1) {
		doc_textbox_to_file(main_v->current_document, main_v->current_document->filename);
	}
	DEBUG_MSG("view_in_netscape, main_v->current_project.basedir=%p\n", main_v->current_project.basedir);
	if ((main_v->current_project.basedir != NULL)
		&& (strlen(main_v->current_project.basedir) > 1)
		&& (strlen(main_v->current_project.webdir) > 1)) {
		/* convert the local filename to an URL (in the project)
		   so it works with dynamic content */
		DEBUG_MSG("view_in_netscape, basedir=%s, webdir=%s, filename=%s\n", main_v->current_project.basedir, main_v->current_project.webdir,
				  main_v->current_document->filename);
		url = strip_common_path(main_v->current_document->filename, main_v->current_project.basedir);
		DEBUG_MSG("view_in_netscape, url=%s\n", url);
		url2 = g_strconcat(main_v->current_project.webdir, url, NULL);
	} else {
             url2 = (gchar *) malloc (strlen (main_v->current_document->filename) + 10);
             url2 = strcpy (url2, "file://");
             strcat (url2, main_v->current_document->filename);
		DEBUG_MSG("view_in_netscape, filename=%s, url2=%s\n", main_v->current_document->filename, url2);
	}
	DEBUG_MSG("view_in_netscape, url2=%s\n", url2);
	command = g_strdup_printf(main_v->props.cfg_browser_cline, url2);
	statusbar_message("Sending URL to browser", 1000);
	rcode = system(command);
	g_free(command);
	DEBUG_MSG("view_in_netscape, rcode = %d\n", rcode);
	if (rcode == 0) {
		goto out_free;
		/*everything was ok */
	} else {
		statusbar_message(_("Browser is not running, starting browser"), 2000);
		/* this part is now only valid for netscape .... */
		command = g_strdup_printf("netscape %s &", url2);
		DEBUG_MSG("view_in_netscape, command=%s\n", command);
		system(command);
		g_free(command);
	}
  out_free:
	g_free(url2);
}

static void key_press_lcb(GtkWidget * widget, GdkEventKey * event, gpointer data)
{
	DEBUG_MSG("key_press_callback, Value is .%d.\n", event->keyval);
	/* Escape */
	if (event->keyval == GDK_Escape) {
		closed = 1;
		close(sockfd);
		gtk_text_thaw(GTK_TEXT(main_v->current_document->textbox));
		DEBUG_MSG("key_press_callback, socket closed and document thawed\n");
	}

	if (main_v->current_document->highlightstate) {
		doc_need_highlighting(main_v->current_document);
	}
}


static void open_from_web_lcb(GtkWidget * widget, gpointer data)
{
	gint return_code;
	gint signal_code;
	gchar *url_string = NULL;
	GtkWidget *entry;

	if (data) {
		entry = GTK_COMBO((GtkWidget *) data)->entry;
		url_string = gtk_editable_get_chars(GTK_EDITABLE(entry), 0, -1);
	}
	gtk_widget_destroy(GTK_WIDGET(gtk_widget_get_toplevel(widget)));
	if (!data) {
		return;
	}

	main_v->current_project.urllist = add_to_stringlist(main_v->current_project.urllist, url_string);

	/* Bind escape key to cancel d/l */

	signal_code = gtk_signal_connect(GTK_OBJECT(main_v->main_window), "key_press_event", GTK_SIGNAL_FUNC(key_press_lcb), NULL);

	return_code = open_web(url_string);
	switch (return_code) {
	case 0:
		break;
	case 1:
		error_dialog(_("Error"), _("That looks like a secure server,\nBluefish doesn't support them"));
		break;
	case 2:
		error_dialog(_("Error"), _("Invalid address"));
		break;
	case 3:
		error_dialog(_("Error"), _("Host name lookup failure"));
		break;
	case 4:
		error_dialog(_("Error"), _("Couldn't create socket"));
		break;
	case 5:
		error_dialog(_("Error"), _("The network is unreachable"));
		break;
	case 6:
		error_dialog(_("Error"), _("Can't send data"));
		break;
	case 7:
		error_dialog(_("Error"), _("Didn't send all the data"));
		break;
	case 8:
		error_dialog(_("Error"), _("Can't open file"));
		break;
	case 9:
/* The used cancelled the d/l, do nothing */
		break;
	default:
		error_dialog(_("Error"), _("Unknown error"));
		break;
	}
	g_free(url_string);
	DEBUG_MSG("open_from_web_callback, disconnecting key_press_callback()\n");
	gtk_signal_disconnect(GTK_OBJECT(main_v->main_window), signal_code);
}


void open_from_web_cb(GtkWidget * widget, gpointer data)
{
	GtkWidget *win, *table, *combo;
	GtkWidget *but1, *but2;

	win = window_with_title(_("Open from Web"), GTK_WIN_POS_MOUSE, GTK_WINDOW_DIALOG, 5);

	table = gtk_table_new(3, 2, 0);
	gtk_container_add(GTK_CONTAINER(win), table);

	combo = combo_with_popdown("", main_v->current_project.urllist, 1);
	gtk_widget_set_usize(combo, 350, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("URL:")), 0, 2, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), combo, 0, 2, 1, 2);
	but1 = bf_stock_ok_button(open_from_web_lcb, combo);
	but2 = bf_stock_cancel_button(open_from_web_lcb, NULL);
	gtk_table_attach_defaults(GTK_TABLE(table), but1, 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), but2, 1, 2, 2, 3);
	gtk_widget_show_all(win);
}


void re_check_lcb(GtkWidget * widget, GtkWidget * window)
{
	gtk_widget_destroy(window);
	run_weblint_cb(NULL, NULL);
}


void selection_made_lcb(GtkWidget * clist, gint row, gint column, GdkEventButton * event, gpointer data)
{

/*  Every time a list item is selected or unselected this checks
   if it was also a double or triple click, if so goToLine is called */

	gchar *text;
	gchar *bracket_ptr;
	gint line_number;
	gtk_clist_get_text(GTK_CLIST(clist), row, column, &text);

	if (event->type == GDK_2BUTTON_PRESS || event->type == GDK_3BUTTON_PRESS) {

/*  Find first bracket, increment, atoi rest of string, atoi will
   stop at second bracket (we hope) */

		bracket_ptr = strchr(text, '(');
		bracket_ptr++;

/* Mark that in the record books, Neil uses a pointer increment! */

		line_number = atoi(bracket_ptr);
		go_to_line(line_number, 1);
	}
}

void run_weblint_cb(GtkWidget * widget, gpointer data)
{
	gint rcode, row, code;
	GtkWidget *ext_window, *list, *close_button, *recheck_button;
	GtkWidget *vbox, *hbox;
	GtkWidget *scrolwin;
	gchar *temp, *html_file, *output_file, *command;
	gchar *text[1];
	FILE *fd;
	struct stat st_output_file;

	output_file = g_strdup_printf("%s", "weblint.out");

/* Current HTML file saved to filename 'untitled' */

	html_file = g_strdup_printf("%s", "untitled");

	statusbar_message(_("Running Weblint"), 1000);

/* Main Window */

	ext_window = window_with_title(_("Weblint output"), GTK_WIN_POS_NONE, GTK_WINDOW_TOPLEVEL, 10);
/*
	what the F is this? adding callback function NULL to an event ??
	gtk_signal_connect(GTK_OBJECT(ext_window), "destroy", NULL, ext_window);
	gtk_signal_connect(GTK_OBJECT(ext_window), "delete_event", NULL, ext_window);
	*/
	gtk_window_set_policy(GTK_WINDOW(ext_window), TRUE, TRUE, FALSE);
	gtk_widget_set_usize(ext_window, 550, 350);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(ext_window), vbox);

	/* since GTK 1.2 one should use a scrolledwindow for a clist */
	scrolwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox), scrolwin, TRUE, TRUE, 0);
	gtk_widget_show(scrolwin);
	list = gtk_clist_new(1);
	gtk_clist_set_shadow_type(GTK_CLIST(list), GTK_SHADOW_OUT);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolwin), list);
	gtk_widget_show(list);
	gtk_widget_show(vbox);
	flush_queue();

	gtk_signal_connect(GTK_OBJECT(list), "select_row", GTK_SIGNAL_FUNC(selection_made_lcb), NULL);

	gtk_signal_connect(GTK_OBJECT(list), "unselect_row", GTK_SIGNAL_FUNC(selection_made_lcb), NULL);

/*      Button box */

	hbox = gtk_hbox_new(TRUE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	recheck_button = gtk_button_new_with_label(_("Recheck"));
	gtk_box_pack_start(GTK_BOX(hbox), recheck_button, TRUE, TRUE, 0);
	gtk_widget_show(recheck_button);

	gtk_signal_connect(GTK_OBJECT(recheck_button), "clicked", GTK_SIGNAL_FUNC(re_check_lcb), GTK_OBJECT(ext_window));

	close_button = gtk_button_new_with_label(_("Close"));
	gtk_box_pack_start(GTK_BOX(hbox), close_button, TRUE, TRUE, 0);

/*  GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);
   gtk_widget_grab_default (close_button); */

	gtk_widget_show(close_button);

	gtk_signal_connect_object(GTK_OBJECT(close_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(ext_window));
	command = main_v->props.cfg_weblint_cline;

	/* Exec Weblint */

	doc_textbox_to_file(main_v->current_document, html_file);
	temp = g_strdup_printf("%s %s > %s 2>/dev/null", command, html_file, output_file);
	flush_queue();

	DEBUG_MSG("Weblint command: %s\n", temp);
	rcode = system(temp);
	flush_queue();

	if (rcode == 32512 || rcode == 32256) {

/*  return code == 32512, seems to be 'no weblint.' Tell user to
   install brainModule */
		gtk_widget_destroy(ext_window);
		error_dialog(_("Weblint"),
					 _
					 ("You don't appear to have weblint installed \nTo use this option you will need to download weblint from:\nhttp://www.cre.canon.co.uk/~neilb/weblint/"));

	} else {
		code = stat(output_file, &st_output_file);
		if (code == -1) {
			DEBUG_MSG("Error stat file: %s\n", output_file);
			error_dialog(_("Weblint"), _("Error stat file"));
		} else {
			if (st_output_file.st_size) {
				fd = fopen(output_file, "r");
				if (fd != NULL) {
					DEBUG_MSG("Open output file: %s\n", output_file);
					text[0] = g_malloc(512);
					gtk_clist_freeze(GTK_CLIST(list));
					while (fgets(text[0], 512, fd) != NULL) {
						DEBUG_MSG("Message: %s\n", text[0]);
						row = gtk_clist_append(GTK_CLIST(list), text);
					}
					gtk_clist_thaw(GTK_CLIST(list));
					g_free(text[0]);
					fclose(fd);
				};

				code = unlink(output_file);
				if (code == -1) {
					DEBUG_MSG("Cannot delete file %s\n", output_file);
					error_dialog(_("Weblint"), _("Error delete stdout temporary file"));
				}

			};
		};

		flush_queue();
		gtk_widget_show(ext_window);
	}

	code = unlink(html_file);
	if (code == -1) {
		DEBUG_MSG("Cannot delete file %s\n", html_file);
		error_dialog(_("Weblint"), _("Error delete temporary saved file"));
	}

	g_free(temp);
	g_free(html_file);
	g_free(output_file);
}

/* Internal preview using gtkxmhtml */
/* Added by Pablo De Napoli, updated by Olivier Sessink */

#ifdef WITH_INTERNAL_PREVIEW

static void end_preview_lcb (GtkWidget *preview_window, gpointer data)
{
 gtk_widget_destroy(main_v->preview->win);
 g_free(main_v->preview);
 main_v->preview = NULL;
}

void preview_cb(GtkWidget * widget, gpointer data) {

	gchar *preview_current_text;
	gchar *title;

	if ( main_v->preview == NULL) {
		main_v->preview = g_malloc(sizeof(Tpreview));

		main_v->preview->win = window_full(NULL, GTK_WIN_POS_NONE, GTK_WINDOW_TOPLEVEL, 0
		 , end_preview_lcb,  NULL);

 
	 /* by default , use the same size of the main window */
		if ((main_v->props.main_window_h < gdk_screen_height()) && (main_v->props.main_window_w < gdk_screen_width())) {
			gtk_window_set_default_size(GTK_WINDOW(main_v->preview->win), main_v->props.main_window_w, main_v->props.main_window_h);
		};

		main_v->preview->html = gtk_xmhtml_new ();
		gtk_container_add (GTK_CONTAINER (main_v->preview->win), main_v->preview->html);
		gtk_widget_show (main_v->preview->html);
		gtk_widget_show (main_v->preview->win);
	}
	preview_current_text = gtk_editable_get_chars(GTK_EDITABLE(main_v->current_document->textbox),0,-1);
	if (preview_current_text) {

		if (main_v->current_document->filename && strlen(main_v->current_document->filename) > 1) {
			title = g_strconcat(_("Bluefish Preview:"),strip_filename(main_v->current_document->filename),NULL);
		} else {
			title = g_strdup(_("Bluefish Preview: Untitled"));
		}
		gtk_window_set_title(GTK_WINDOW(main_v->preview->win), title);
		g_free(title);
		
		if (strlen(preview_current_text) > 1) {
			gtk_xmhtml_source (GTK_XMHTML (main_v->preview->html),preview_current_text);
		}
		g_free(preview_current_text);
	}
}
#endif

