/*
 * This file is part of sudognu.
 *
 * Copyright (C) 2007 Jens Baaran, Germany.
 ******************************************************************************/

#include <stdio.h>
#include <pthread.h>
#include "sudoku.h"

/*
 ******************************************************************************/
int get_random_cand(t_field cell) {
	extern FILE *devurandom;
	unsigned int istat, i;
	
	if (devurandom != NULL) {
		if (fread(&istat,sizeof(unsigned int),1,devurandom) != 1) {
			fprintf(stderr,"error while trying to read from /dev/urandom\n");
		}
	} else {
		fprintf(stderr,"error: /dev/urandom isn't open for reading\n");
	}
	istat = istat % cell.ncand;

	for (i=0; i<SIZE2; i++) {
		if (cell.cand[i] > 0) {
			if (istat == 0) return(i);
			else istat--;
		}
	}
	return(-1);
}

/*
 ******************************************************************************/
void update_num_candidates(t_sudoku *sudoku) {
	
	int r, c, cc;
	int size = sudoku->size;
	
	for (r=0; r<size; r++) {
		for (c=0; c<size; c++) {
			sudoku->grid[r][c].ncand = 0;
			for (cc=0; cc<size; cc++) {
				if (sudoku->grid[r][c].cand[cc] != 0) sudoku->grid[r][c].ncand += 1;
			}
		}
	}
}

/*
 ******************************************************************************/
void remove_candidates(t_sudoku *sudoku, int row, int col) {

	int r, c;
	int br = (row / SIZE);
	int bc = (col / SIZE);
	int cc = sudoku->grid[row][col].value-1;
	int size = sudoku->size;

	for (c=0; c<size; c++) sudoku->grid[row][c].cand[cc] = 0;
	for (r=0; r<size; r++) sudoku->grid[r][col].cand[cc] = 0;
	for (r=0; r<size; r++) sudoku->grid[row][col].cand[r] = 0;
	for (r=br*SIZE; r<(br+1)*SIZE; r++) {
		for (c=bc*SIZE; c<(bc+1)*SIZE; c++) {
			sudoku->grid[r][c].cand[cc] = 0;
		}
	}
	update_num_candidates(sudoku);
}

/*
 ******************************************************************************/
void get_candidates(t_sudoku *sudoku) {

	int c, r, cc;
	int size = sudoku->size;
	
	for (r=0; r<size; r++) {
		for (c=0; c<size; c++) {
			for (cc=0; cc<size; cc++) sudoku->grid[r][c].cand[cc] = cc+1;
		}
	}
	for (r=0; r<size; r++) {
		for (c=0; c<size; c++) {
			if (sudoku->grid[r][c].value != 0) remove_candidates(sudoku,r,c);
		}
	}
	update_num_candidates(sudoku);
}

