/*

Copyright (C) 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __libnd_traceset_h
#define __libnd_traceset_h

#include <libnd.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct lnd_traceset LND_TraceSet;

typedef enum {
  LND_TRACESET_ERROR_SKIP,
  LND_TRACESET_ERROR_ABORT,
  LND_TRACESET_ERROR
} LND_TraceSetMode;

typedef gboolean (*LND_TraceSetCB)(LND_TraceSet *set, LND_Trace *trace, void *user_data);


LND_TraceSet    *libnd_traceset_new(void);
LND_TraceSet    *libnd_traceset_copy(const LND_TraceSet *set);
void             libnd_traceset_free(LND_TraceSet *set);

gboolean         libnd_traceset_add_trace(LND_TraceSet *set, LND_Trace *trace);
gboolean         libnd_traceset_add_trace_name(LND_TraceSet *set, const char *file_name);
gboolean         libnd_traceset_add_trace_name_list(LND_TraceSet *set, const char *file_name);

void             libnd_traceset_set_mode(LND_TraceSet *set,
					 LND_TraceSetMode mode);

LND_TraceSetMode libnd_traceset_get_mode(LND_TraceSet *set);

int              libnd_traceset_get_size(LND_TraceSet *set);

void             libnd_traceset_foreach(LND_TraceSet *set,
					LND_TraceSetCB callback,
					void *user_data);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
