/*

Copyright (C) 2000 - 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <nd.h>
#include <nd_gui.h>
#include <nd_tpm_gui.h>
#include <nd_trace_area_gui.h>
#include <nd_trace_registry.h>

static GList      *registry;  /* list<ND_Trace*> */
static LND_Trace  *current_trace;

void     
nd_trace_registry_init(void)
{
  D_ENTER;
  current_trace = NULL;
  registry = NULL;
  D_RETURN;
}


inline void        
nd_trace_registry_set_current(LND_Trace *trace)
{
  if (!trace)
    return;

  D_ENTER;

  current_trace = trace;
  nd_gui_num_packets_set();
  nd_gui_set_trace_status(trace);
  nd_gui_set_windowtitle(libnd_trace_get_name(trace));
  nd_gui_sync_menus();
  nd_gui_update_area_indicator();
  nd_tpm_dialog_sync();
  nd_trace_area_dialog_sync(NULL);

  D_RETURN;
}


inline LND_Trace   *
nd_trace_registry_get_current(void)
{
  return current_trace;
}


void     
nd_trace_registry_add(LND_Trace *trace)
{
  if (!trace)
    return;

  registry = g_list_append(registry, trace);

  nd_gui_trace_add(trace);
}


void     
nd_trace_registry_remove(LND_Trace *trace)
{
  if (!trace)
    return;
  
  nd_gui_trace_remove(trace);
  registry = g_list_remove(registry, trace);

  if (current_trace == trace)
    {
      if (!registry)
	current_trace = NULL;
      else
	current_trace = (LND_Trace *) registry->data;
    }

  nd_gui_update_area_indicator();
  nd_gui_update_view_indicator();
  nd_gui_num_packets_set();
}


void     
nd_trace_registry_foreach(ND_TraceFunc callback, void *user_data)
{
  LND_Trace *trace;
  GList *l;

  if (!callback)
    return;

  for (l = registry; l; l = g_list_next(l))
    {
      trace = (LND_Trace *) l->data;
      callback(trace, user_data);
    }
}

