/*

Copyright (C) 2000 - 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <nd.h>
#include <nd_dialog.h>
#include <nd_filter_gui.h>
#include "interface.h"

#include "nd_bpf.h"


static LND_FilterFactory *bpf_ff;

static void
bpf_filter_create(void)
{
  static GtkWidget *bpf_dialog;

  if (!bpf_dialog)
    bpf_dialog = create_bpf_dialog();

  gtk_widget_show(bpf_dialog);
}

static void
bpf_filter_modify(LND_Filter *filter)
{
  D(("Modifying %s not implemented yet\n", filter->name));
}


/* ---- Plugin hooks below --------------------------------------------- */


const char *
name(void)
{
  return _("/Filters/BPF Filter");
}


const char *
description(void)
{
  return _("A plugin to create BPF filters.");
}


const char *
author(void)
{
  return _("Christian Kreibich, <christian@whoop.org>");
}

const char *
version(void)
{
  return VERSION_MAJOR;
}


gboolean
init(void)
{
  if (! libnd_plugin_find("BPF-Filter"))
    return FALSE;

  /* We add a filter creation hook to the plugin dialog, that's
   * all. This plugin has no run() method! It therefore also doesn't
   * show up in the plugins menu -- we don't want the user to be
   * able to click on a button there.
   */
  bpf_ff = libnd_filter_factory_new(_("BPF Filter"),
				    bpf_filter_create,
				    bpf_filter_modify);

  libnd_filter_factory_register(bpf_ff);

  return TRUE;
}


LND_FilterFactory *
nd_bpf_get_factory(void)
{
  return bpf_ff;
}
