/******************************************************************************
 * $Id: FilterBarButton.h 1992 2007-05-30 06:10:05Z livings124 $
 *
 * Copyright (c) 2006-2007 Transmission authors and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *****************************************************************************/

#import <Cocoa/Cocoa.h>

@interface FilterBarButton : NSButton
{
    NSImage * fButtonNormal, * fButtonNormalDim, * fButtonOver,
            * fButtonPressed, * fButtonSelected, * fButtonSelectedDim;
    int fCount;
    
    BOOL fEnabled;
    NSTrackingRectTag fTrackingTag;
}

- (void) setCount: (int) count;
- (void) setEnabled: (BOOL) enable;

- (void) resetBounds: (NSNotification *) notification;

- (void) setForActive: (NSNotification *) notification;
- (void) setForInactive: (NSNotification *) notification;

@end
