/*  This file is part of the KDE project
    Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "browseriface.h"
#include "view.h"

BrowserInterface::BrowserInterface( BrowserView *view, const char *name )
    : KParts::BrowserInterface( view, name )
{
    m_view = view;
}

uint BrowserInterface::historyLength() const
{
    return m_view->historyLength();
}

#ifdef QT_NO_PROPERTIES
QVariant BrowserInterface::property( const char *name ) const
{
    if ( strcmp( name, "historyLength" ) == 0 )
        return QVariant( historyLength() );

    return QVariant();
}
#endif

void BrowserInterface::goHistory( int steps )
{
    m_view->goHistoryDelayed( steps );
}

#include "browseriface.moc"

