#ifndef __ksslinfodlg_h__
#define __ksslinfodlg_h__

/*  This file is part of the KDE project
    Copyright (C) 2000-2003 George Staikos <staikos@kde.org>
    Copyright (C) 2000 Malte Starostik <malte@kde.org>
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>
    Copyright (C) 2002 Paul Chitescu <pchitescu@pchitescu.myip.org>
    Copyright (C) 2002-2004 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

*/

#include <qstring.h>

#include <ksslcertificate.h>
#include <kssl.h>

class QWidget;

class KSSLInfoDlg
{
public:
    KSSLInfoDlg( bool secureConnection, QWidget *parent, const char *, bool );

    void setSecurityInQuestion(bool);

    void setup( KSSLCertificate* /*cert*/,
                const QString &ip,
                const QString &url,
                const QString &cipher,
		const QString &chiperdesc,
                const QString &sslversion,
                int usedbits,
                int bits,
                KSSLCertificate::KSSLValidation certstate);

    void exec();

private:
    bool m_ssl;
    QWidget *m_parent;
    QString m_moreInfo;
};

#endif
