/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __ksocks_h__
#define __ksocks_h__

#include <qglobal.h>

#if !defined(Q_WS_WIN)

#include <sys/types.h>
#include <netsupp.h>

#include <unistd.h>

typedef unsigned ksocklen_t;

class KSocks
{
public:
    inline int bind( int sockfd, sockaddr *my_addr, ksocklen_t addrlen )
    { return ::bind( sockfd, my_addr, addrlen ); }
    // New in 3.2 ?
    inline int bind( int sockfd, const sockaddr *my_addr, ksocklen_t addrlen )
    { return ::bind( sockfd, my_addr, addrlen ); }

    inline int listen( int s, int backlog )
    { return ::listen( s, backlog ); }

    inline int select( int n, fd_set *readfds, fd_set *writefds, fd_set *exceptfds,
                       struct timeval *timeout)
    { return ::select( n, readfds, writefds, exceptfds, timeout ); }

    inline int accept( int s, sockaddr *addr, ksocklen_t *addrlen )
    { return ::accept( s, addr, addrlen ); }

    inline int connect( int sockfd, const sockaddr *serv_addr, ksocklen_t addrlen )
    { return ::connect( sockfd, serv_addr, addrlen ); }

    inline signed long int read ( int fd, void *buf, unsigned long int count )
    { return ::read( fd, buf, count ); }

    inline long int write( int fd, const void *buf, unsigned long int count )
    { return ::write( fd, buf, count ); }

    inline int recv(int s, void *buf, unsigned long int len, int flags)
    { return ::recv(s, buf, len, flags); }

    inline int getsockname( int s, sockaddr *name, ksocklen_t *namelen )
    { return ::getsockname( s, name, namelen ); }

    inline int getpeername( int s, sockaddr *name, ksocklen_t *namelen )
    { return ::getpeername( s, name, namelen ); }

    // Needed by kdelibs 3.1.3
    inline bool hasWorkingAsyncConnect() const { return false; }
    
    // Needed by kdelibs 3.4.0
    void disableSocks() {}
    
    static KSocks *self()
    {
        if ( !s_self )
            s_self = new KSocks;
        return s_self;
    }

private:
    static KSocks *s_self;
};

#endif  

#endif

