/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>
    Copyright (C) 2002 Paul Chitescu <Paul.Chitescu@IMC-Group.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kmessagebox_h__
#define __kmessagebox_h__

#include <qmessagebox.h>
#include <qvaluelist.h>
#include <qguardedptr.h>

#include <kstdguiitem.h>

// ### this is an ugly hack, to get the QInputDialog wrapper for
// khtml/ecma/kjs_window.cpp, in case QT_NO_INPUTDIALOG is
// defined (kjs_window.cpp includes kmessagebox)
#include <kinputdialog.h>

class MessageBoxQueuer : public QObject
{
    Q_OBJECT
public:
    static MessageBoxQueuer *self();

    static void queue( QWidget *parent, int type, const QString &text,
                       const QString &caption );

private:
    MessageBoxQueuer() {}

private slots:
    void dequeue();

private:
    struct Entry
    {
        QGuardedPtr<QWidget> parent;
        int type;
        QString text;
        QString caption;
    };

    QValueList<Entry> m_queue;
    bool m_lock;

    static MessageBoxQueuer *s_self;
};

class KMessageBox
{
public:

    enum
    {
        QuestionYesNo = 1,
        WarningYesNo = 2,
        WarningContinueCancel = 3,
        WarningYesNoCancel = 4,
        Information = 5,
        // Reserved for: SSLMessageBox = 6
        Sorry = 7,
        Error = 8,
        WarningContinueCancelList = 9
    };

    enum Answer { Ok = 1, Cancel = 2, Yes = 3, No = 4, Continue = 5 };

    // Needed for kdelibs 3.1 
    enum OptionsType { Notify = 1, AllowLink = 2 };
    
    static void error( QWidget *parent,
                       const QString &text,
                       const QString &caption = QString::null )
        { information( parent, text, caption ); }

    static void sorry( QWidget *parent,
                       const QString &text,
                       const QString &caption = QString::null )
        { information( parent, text, caption ); }

    static int questionYesNo( QWidget *parent,
                              const QString &text,
                              const QString &caption = QString::null,
                              const QString &buttonYes = QString::null,
                              const QString &buttonNo = QString::null,
                              const QString &dontaskmeagain = QString::null,
                              bool /*okButton*/ = false )
        { return warningYesNoCancel( parent, text, caption, buttonYes, buttonNo, dontaskmeagain, false ); }

    // changed for kdelibs 3.1
    static void information( QWidget *parent,
                             const QString &text,
                             const QString &caption = QString::null,
                             const QString & /*dontShowAgainName*/ = QString::null )
        { warningYesNoCancel( parent, text, caption, QString::null, QString::null, QString::null, false, true ); }

    // changed for kdelibs 3.1
    static int warningYesNo( QWidget *parent,
                             const QString &text,
                             const QString &caption = QString::null,
                             const QString &buttonYes = QString::null,
                             const QString &buttonNo = QString::null,
                             const QString & = QString::null,
			     int = Notify )
        { return questionYesNo( parent, text, caption, buttonYes, buttonNo ); }

    static int warningContinueCancel( QWidget *parent,
                             const QString &text,
                             const QString &caption = QString::null,
                             const QString &buttonContinue = QString::null,
                             const QString &buttonCancel = QString::null );

    static int warningYesNoCancel( QWidget *parent,
                             const QString &text,
                             const QString &caption = QString::null,
                             const QString &buttonYes = QString::null,
                             const QString &buttonNo = QString::null,
                             const QString &/*dontaskmeagain*/ = QString::null,
                             bool cancelButton = true,
                             bool okButton = false );

    // ### HACK!!! new for KDE3


/*    static int warningContinueCancelList(QWidget *parent,
                             const QString &text,
                             const QStringList &strlist,
                             const QString &caption = QString::null,
                             const QWidget &buttonContinue = QWidget(),
                             const QString &dontAskAgainName = QString::null) */
     static int warningContinueCancelList(QWidget *parent,
                         const QString &text,
                         const QStringList & /* strlist */,
                         const QString & /* caption */ = QString::null,
                         const KGuiItem & /* buttonContinue */ = KStdGuiItem::cont(),
                         const QString & /* dontAskAgainName */ = QString::null,
                         int /* options */ = Notify)
        { return questionYesNo( parent, text, QString::null, QString::null, QString::null ); }
    
    static void queuedMessageBox( QWidget *parent,
                                  int type,
                                  const QString &text,
                                  const QString &caption )
        { MessageBoxQueuer::queue( parent, type, text, caption ); }

};


#endif
