/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __klineedit_h__
#define __klineedit_h__

#include <qlineedit.h>

#include <kcompletionbox.h>

class KCompletion
{
public:
    void setItems( const QStringList & ) {} 
    void clear() {}
    bool isEmpty() const { return true; }
};

class KLineEdit : public QLineEdit
{
    Q_OBJECT
public:
    KLineEdit( QWidget *parent = 0, const char *name = 0 )
        : QLineEdit( parent, name ) {}

    KCompletion *completionObject() { return &m_completionObj; }
    KCompletion *compObj() { return &m_completionObj; }

    KCompletionBox *completionBox(bool /* create */ = true) { 
	    return &m_completionBox; }

    void setContextMenuEnabled( bool ) {}

private:
    KCompletion m_completionObj;
    KCompletionBox m_completionBox;
};

#endif

