/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __klibloader_h__
#define __klibloader_h__

#include <qobject.h>
#include <qasciidict.h>
#include <qcstring.h>
#include <qstringlist.h>

#include <kglobal.h>

class KLibFactory;
class KInstance;

class KLibrary
{
public:
    KLibrary( const QCString &name );
    QString name() const { return QString::fromLatin1( m_name ); }

    void registerSymbol( const char *key, void *symbol );
    virtual void *symbol( const char *name ) const;
    
    // Needed since KDE 3.4
    virtual bool hasSymbol( const char* name ) const;

    KLibFactory *factory();

    void unload() const;

    virtual ~KLibrary();
private:

    QAsciiDict<void> m_symbols;
    QCString m_name;
    KLibFactory *m_factory;
};

class KLibFactory : public QObject
{
    Q_OBJECT
public:
    KLibFactory( QObject *parent = 0, const char *name = 0 )
        : QObject( parent, name ) {}

    QObject *create( QObject *parent, const char *name, const char *classname, const QStringList &args = QStringList() )
        { return createObject( parent, name, classname, args ); }

protected:
    virtual QObject *createObject( QObject *, 
	    const char *, const char *, const QStringList & ) = 0;
    // Needed for kdelibs 3.2
    virtual void virtual_hook( int id, void* data );

signals:
    void objectCreated( QObject * );
};

class KLibLoader
{
public:
    enum LibraryOpeningPolicy { TryDlopen, CreateStaticWrapper };

    KLibLoader() { s_self = this; }

    KLibrary *library( const char *name, LibraryOpeningPolicy policy = TryDlopen );

    KLibrary *globalLibrary( const char *name );

    KLibFactory *factory( const char *name, LibraryOpeningPolicy policy = TryDlopen )
        { return library( name, policy )->factory(); }

    void unloadLibrary( const char * ) {}

    static KLibLoader *self();

private:
    QCString findLibrary( const QCString &name );

    static KLibLoader *s_self;
    QAsciiDict<KLibrary> m_libs;
};

#endif
