/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <kstandarddirs.h>
#include <kconfig.h>
#include "kinstance.h"
#include "kaboutdata.h"

KInstance::KInstance( const char *name ) : m_name(name)
{
    init();
}

KInstance::KInstance( KAboutData *data )
{
    init();
    m_name = data->appName();
}

KInstance::~KInstance()
{
    delete m_dirs;
}

void KInstance::init()
{
    m_dirs = new KStandardDirs();
    m_dirs->addKDEDefaults();
    _config = 0;
}

KConfig *KInstance::config() const
{
    if ( !_config )
        _config = new KConfig( QString::fromLatin1( m_name ) + "rc" );
    return _config;
}
