/*  This file is part of the KDE project
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kdatastream__h
#define __kdatastream__h

#include <qdatastream.h>

inline QDataStream & operator << (QDataStream & str, bool b)
{
  str << Q_INT8(b);
  return str;
}

inline QDataStream & operator >> (QDataStream & str, bool & b)
{
  Q_INT8 l;
  str >> l;
  b = bool(l);
  return str;
}

inline QDataStream & operator << (QDataStream & str, long long int ll)
{
  Q_INT32 l1,l2;
  l1 = ll & 0xffffffffLL;
  l2 = ll >> 32;
  str << l1 << l2;
  return str;
}

inline QDataStream & operator >> (QDataStream & str, long long int&ll)
{
  Q_INT32 l1,l2;
  str >> l1 >> l2;
  ll = ((long long int)(l2) << 32) + (long long int) l1;
  return str;
}

inline QDataStream & operator << (QDataStream & str, unsigned long long int ll)
{
  Q_UINT32 l1,l2;
  l1 = ll & 0xffffffffLL;
  l2 = ll >> 32;
  str << l1 << l2;
  return str;
}

inline QDataStream & operator >> (QDataStream & str, unsigned long long int &ll)
{
  Q_UINT32 l1,l2;
  str >> l1 >> l2;
  ll = ((unsigned long long int)(l2) << 32) + (unsigned long long int) l1;
  return str;
}

#endif
