/* This file is part of the KDE libraries
    Copyright (C) 2000-2001 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __dcopclient_h__
#define __dcopclient_h__

#include <qlist.h>
#include <qcstring.h>

class DCOPClientTransaction;

#include "dcopobject.h"
#include "dcopdispatcher.h"

namespace KIO
{
    class Connection;
}

class DCOPClient
{
public:
    // internal hack ;-)
    enum callType { Send, Call };

    DCOPClient();
    ~DCOPClient();

    QCString registerAs( const char *, bool ) { return 0; }

    QCString appId() const { return QCString( "konq-embed" ); }

    bool isApplicationRegistered( const QCString & ) { return true; }

    bool attach() { return true; }

    DCOPClientTransaction *beginTransaction()
        { return DCOPDispatcher::self()->beginTransaction(); }

    void endTransaction( DCOPClientTransaction *transaction, QCString &replyType, QByteArray &replyData )
        { DCOPDispatcher::self()->endTransaction( transaction, replyType, replyData ); }

    bool send( const QCString &remApp, const QCString &remObj, const QCString &remFun,
               const QByteArray &data );

    bool call( const QCString &remApp, const QCString &remObj, const QCString &remFun,
               const QByteArray &data,
               QCString &replyType, QByteArray &replyData );

    void setDaemonMode( bool daemonMode );

#if !defined(Q_WS_WIN)
    // extension
    static void setGlobalConnection( KIO::Connection *conn ) { s_connection = conn; }
    static KIO::Connection *globalConnection() { return s_connection; }

    static DCOPClient* mainClient();
  
private:
    static KIO::Connection *s_connection;
#endif
};

#endif
