/*
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include "interface.h"
#include "load.h"
#include "free.h"
#include "alloc.h"
#include "def.h"
#include "config.h"
#include "options.h"

static gboolean debug = FALSE;
static gboolean disable_animation = FALSE;

static GOptionEntry entries[] = 
{
  { "debug", 0, 0, G_OPTION_ARG_NONE, &debug, N_("Start in debug mode, for developers only"), NULL },
  { "disable-animation", 0, 0, G_OPTION_ARG_NONE, &disable_animation, N_("Do not display cards' move. Useful on old computers."), NULL },
  { NULL }
};

int main(int argc, char *argv[])
{
	struct _prog prog_data = 
	{
		/* see def.h for more details 
		 * about struct _prog */
		
		/* lists ... */
		NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		/* move card */
		NULL, 
		/* pixmap, bitmap and widgets */
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, 
		/* allwidgets array */
		NULL,
		/* [enum egstate, int, int, ...] */
		LOADING, -1, -1, -1, -1, -1, -1, -1, 0, 
		/* points, declarations, report */
		{0, 0}, {0, 0}, -1, 0,
		
		/*- only this part can be customised -*/
		/*- output stream, should be stdout or a file (FILE*) -*/
		NULL, 
		/*- animation -*/
		TRUE,
		/*- declaration -*/
		TRUE,
		/* Showing declarations */
		FALSE,
		/* Click on a card means drops it instantly */
		FALSE,
		/* Multiplier for space between cards */
		1.0,
		/* Player names */
		NULL,
		/* blink id */
		-1
	};
	
	GOptionContext* context;
	
	GError *error = NULL;
	
	context = g_option_context_new ( _("- a fun GTK card game") );
	
	if(context)
	{
		g_option_context_add_main_entries (context, entries, GETTEXT_PACKAGE);
		g_option_context_add_group (context, gtk_get_option_group (TRUE));
		g_option_context_parse (context, &argc, &argv, &error);
		
		g_free(context);
		
		if(debug)
			prog_data.output = stdout;
		
		load_properties(&prog_data);
		
		if(disable_animation)
			prog_data.animation = FALSE;
	
		interface_create(&prog_data);
		
		if(prog_data.allwidgets != NULL)
		{
			
			gtk_widget_show_all(prog_data.allwidgets[0]);

			gtk_main();
			
			
			free_prog(&prog_data);
			
		}
	}
	
	return(0);
}
