/*
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <gtk/gtk.h>
#include "def.h"


/* find_moveable_card : when the user click 
 * on the game area, we need to find what 
 * card is candidate to be a moving card. 
 * This means scanning each GList of visible 
 * cards in the order of visibility. From the 
 * nearer to the user to the deeper.
 * A card which is on the area of the click 
 * event is not automaticaly a candidate if 
 * another card is hiding it.
 * 
 * GList *ptr: a GList containing cards element 
 * as struct _card (see file def.h for more 
 * details about this struct).
 * 
 * GdkEventButton *event: contains x,y 
 * position of the mouse click.
 * 
 * struct _prog *prog_data: see file def.h
 * 
 * What is needed in the struct _prog:
 * 
 * prog_data->movecard : a struct _movingcard
 * defined in def.h file, where we will 
 * record a pointer to the card selected in 
 * case the user keep the mouse button 
 * pressed. He wants to drag a card. We need 
 * to find it first. And keep a trace of it 
 * easily to make it move later. This is 
 * what the struct _movingcard is used for.
 * 
 * return gboolean: TRUE if we found a candidate.
 * FALSE otherwise.
 */
gboolean find_moveable_card(GList *ptr, GdkEventButton *event, 
	struct _prog *prog_data)
{
	struct _card *data_ptr;
	gboolean found = FALSE;
	
	while( ptr )
	{
		data_ptr = ptr->data;
		
		if(event->button == 1 && (gint) event->x >= data_ptr->dim.x 
			&& (gint) event->y >= data_ptr->dim.y 
			&& (gint) event->x < data_ptr->dim.x+data_ptr->dim.w
			&& (gint) event->y < data_ptr->dim.y+data_ptr->dim.h)
		{
			if(	data_ptr->moveable == TRUE && prog_data->movecard == NULL)
			{
				prog_data->movecard = (struct _movingcard*)
					g_malloc(sizeof( struct _movingcard) );
				
				if( prog_data->movecard )
				{
					prog_data->movecard->card = data_ptr;
					
					prog_data->movecard->dim.w = (gint)event->x - data_ptr->dim.x;
					prog_data->movecard->dim.h = (gint)event->y - data_ptr->dim.y;
					
					prog_data->movecard->dim.x = data_ptr->dim.x;
					prog_data->movecard->dim.y = data_ptr->dim.y;
					
					data_ptr->draw = FALSE;
					
					draw_container(prog_data);
				}
			}
			found = TRUE;
			ptr = NULL;
		}
		else
			ptr = ptr->next;
	}

	return(found);
}
