/* AbiSource Program Utilities
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */
 
// Class definition include.
#include "OD_NotesConfiguration.h"

// Internal includes
#include "OD_ListenerStateAction.h"

// AbiWord includes
#include <ut_misc.h>


/**
 * 
 */
void OD_NotesConfiguration::startElement(const XML_Char* pName,
                                             const XML_Char** ppAtts,
                                             OD_ListenerStateAction& rAction) {
                                                
    const XML_Char* pVal;
                                        
    if (!UT_strcmp("text:notes-configuration", pName)) {
        
        pVal = UT_getAttribute ("text:note-class", ppAtts);
        UT_ASSERT(pVal);
        m_noteClass = pVal;
        
        pVal = UT_getAttribute ("text:citation-style-name", ppAtts);
        if (pVal) {
            m_citationStyleName = pVal;
        }
    }
}


/**
 * 
 */
void OD_NotesConfiguration::endElement(const XML_Char* pName,
                                           OD_ListenerStateAction& rAction) {
                                            
    if (!UT_strcmp("text:notes-configuration", pName)) {
        rAction.popState();
    }
}
