/*
 * msgmle.cpp - subclass of PsiTextView to handle various hotkeys
 * Copyright (C) 2001-2003  Justin Karneges, Michail Pishchagin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include"common.h"
#include"msgmle.h"

//----------------------------------------------------------------------------
// ChatView
//----------------------------------------------------------------------------
ChatView::ChatView(QWidget *parent, const char *name)
: PsiTextView(parent, name)
{
	setWordWrap(WidgetWidth);
	setWrapPolicy(AtWordOrDocumentBoundary);

	setTextFormat(RichText);
	setReadOnly(true);
	setUndoRedoEnabled(false);
	setHScrollBarMode(QScrollView::AlwaysOff);
}

ChatView::~ChatView()
{
}

bool ChatView::focusNextPrevChild(bool next)
{
	return QWidget::focusNextPrevChild(next);
}

void ChatView::keyPressEvent(QKeyEvent *e)
{
	if(e->key() == Key_Escape)
		e->ignore();
#ifdef Q_WS_MAC
	else if(e->key() == Key_W && e->state() & ControlButton)
		e->ignore();
#endif
	else if(e->key() == Key_Return && ((e->state() & ControlButton) || (e->state() & AltButton)) )
		e->ignore();
	else if(e->key() == Key_H && (e->state() & ControlButton))
		e->ignore();
	else if(e->key() == Key_M && (e->state() & ControlButton)) // newline
		insert("\n");
	else if(e->key() == Key_U && (e->state() & ControlButton))
		setText("");
	else
		QTextEdit::keyPressEvent(e);
}

void ChatView::resizeEvent(QResizeEvent *e)
{
	// This fixes flyspray #45
	if(contentsY() == contentsHeight() - visibleHeight())
		scrollToBottom();

	QTextEdit::resizeEvent(e);
}

//----------------------------------------------------------------------------
// ChatEdit
//----------------------------------------------------------------------------
ChatEdit::ChatEdit(QWidget *parent, const char *name)
: PsiTextView(parent, name)
{
	setWordWrap(QTextEdit::WidgetWidth);

	setReadOnly(false);
	setUndoRedoEnabled(true);

	setTextFormat(PlainText);
	setMinimumHeight(48);
}

ChatEdit::~ChatEdit()
{
}

bool ChatEdit::focusNextPrevChild(bool next)
{
	return QWidget::focusNextPrevChild(next);
}

void ChatEdit::keyPressEvent(QKeyEvent *e)
{
	if(e->key() == Key_Escape || (e->key() == Key_W && e->state() & ControlButton))
		e->ignore();
	else if(e->key() == Key_Return && ((e->state() & ControlButton) || (e->state() & AltButton)) )
		e->ignore();
	else if(e->key() == Key_M && (e->state() & ControlButton)) // newline
		insert("\n");
	else if(e->key() == Key_H && (e->state() & ControlButton)) // history
		e->ignore();
	else if(e->key() == Key_S && (e->state() & AltButton))
		e->ignore();
	else if(e->key() == Key_U && (e->state() & ControlButton))
		setText("");
	else if((e->key() == Key_Return || e->key() == Key_Enter) && !(e->state() & ShiftButton) && option.chatSoftReturn)
		e->ignore();
	else if((e->key() == Key_PageUp || e->key() == Key_PageDown) && (e->state() & ShiftButton))
		e->ignore();
	else
		QTextEdit::keyPressEvent(e);
}


