function outputtext(&p,text)
  if (p.ignore) return; end
  v = regexp(text,'@\$"([^"]*)","([^"]*)","([^"]*)"','tokens');
  if (isempty(v))
    error(sprintf('bad line: %s',text));
  end
  filename = sprintf('%s/toolbox/test/wbtest_%s_%d.m',p.sourcepath,p.modulename,p.num);
  fp = fopen(filename,'w');
  if (fp < 0)
    error(sprintf('Unable to open %s for writing',filename));
  end
  fprintf(fp,'%% Regression test function for %s\n',verstring);
  fprintf(fp,'%% This function is autogenerated by helpgen.\n');
  fprintf(fp,'function success = wbtest_%s_%d\n',p.modulename,p.num);
  fprintf(fp,'\n');
  fprintf(fp,'%s;\n',v{1}{1});
  fprintf(fp,'q=%s;\n',v{1}{2});
  fprintf(fp,'success = match_%s(q,y);\n',v{1}{3});
  fprintf(fp,'\n');
  fclose(fp);
  p.num = p.num + 1;
