
// This file contains all FOX functions redefinitions (FOX hacks for various purposes)


// Function taken from the FxTextField class and hacked to get standard background
// when the text field is disabled or is not editable
long FXTextField::onPaint(FXObject*,FXSelector,void* ptr)
{
	FXEvent *ev=(FXEvent*)ptr;
	FXDCWindow dc(this,ev);

	// Draw frame
	drawFrame(dc,0,0,width,height);

	// !!!! Hack to get standard background if disabled or if not editable
	if (!isEnabled() || !isEditable())
		dc.setForeground(baseColor);
	else
		dc.setForeground(backColor);
	// !!!! End of hack
	
	// Draw background
	dc.fillRectangle(border,border,width-(border<<1),height-(border<<1));

	// Draw text, clipped against frame interior
	dc.setClipRectangle(border,border,width-(border<<1),height-(border<<1));
	drawTextRange(dc,0,contents.length());

	// Draw caret
	if(flags&FLAG_CARET)
	{
		int xx=coord(cursor)-1;
		dc.setForeground(cursorColor);
		dc.fillRectangle(xx,padtop+border,1,height-padbottom-padtop-(border<<1));
		dc.fillRectangle(xx-2,padtop+border,5,1);
		dc.fillRectangle(xx-2,height-border-padbottom-1,5,1);
	}
	return 1;
 }


  
#ifndef MIN_PANEL_WIDTH
#define MIN_PANEL_WIDTH 100
#endif

// This function is taken from the FXSplitter class
// and hacked to set a minimum splitter width when moving splitter to right
// It replaces the normal function...
void FXSplitter::moveHSplit(FXint pos)
{
    register FXint smin,smax;
    register FXuint hints;
    hints=window->getLayoutHints();
    if(options&SPLITTER_REVERSED)
    {
        smin=barsize;
        smax=window->getX()+window->getWidth();
        if((hints&LAYOUT_FILL_X)&&(hints&LAYOUT_FIX_WIDTH))
            smax-=window->getDefaultWidth();
    }
    else
    {
        smin=window->getX();
        smax=width-barsize;
        if((hints&LAYOUT_FILL_X)&&(hints&LAYOUT_FIX_WIDTH))
            smin+=window->getDefaultWidth();
    }

    // !!!! Hack to limit the width to a minimum value !!!
    smax=smax-MIN_PANEL_WIDTH;
    split=pos;
    if(split<smin)
        split=smin;
    if(split>smax)
        split=smax;
	// !!!! End of hack
}


// !!!! Hack to change the defaults directories for config files and icons

#define DESKTOP        "xferc"
#define REGISTRYPATH   "/etc:/usr/share:/usr/local/share"

// Read registry
bool FXRegistry::read()
{
    FXString dirname;
    register bool ok=false;


    dirname=FXPath::search(REGISTRYPATH,"xfe");
    if(!dirname.empty())
        ok=readFromDir(dirname,false);

    // Try search along PATH if still not found
    if(!ok)
    {
        dirname=FXPath::search(FXSystem::getExecPath(),"xfe");
        if(!dirname.empty())
            ok=readFromDir(dirname,false);
    }

    // Get path to per-user settings directory
    dirname=FXSystem::getHomeDirectory()+PATHSEPSTRING LOCALPATH;

    // Then read per-user settings; overriding system-wide ones
    if(readFromDir(dirname,true))
        ok=true;

    return ok;
}


// Try read registry from directory
bool FXRegistry::readFromDir(const FXString& dirname,bool mark)
{
    bool ok=false;

    // Directory is empty?
    if(!dirname.empty())
    {
        // First try to load desktop registry
        if(parseFile(dirname+PATHSEPSTRING DESKTOP,false))
            ok=true;

        // Have vendor key
        if(!vendorkey.empty())
        {
            if(parseFile(dirname+PATHSEPSTRING+vendorkey+PATHSEPSTRING+vendorkey,false))
                ok=true;
            // Have application key
            if(!applicationkey.empty())
                if(parseFile(dirname+PATHSEPSTRING+vendorkey+PATHSEPSTRING+applicationkey,mark))
                    ok=true;
        }

        // No vendor key
        else
        {
            // Have application key
            if(!applicationkey.empty())
                if(parseFile(dirname+PATHSEPSTRING+applicationkey,mark))
                    ok=true;
        }
    }
    return ok;
}


// Write registry
bool FXRegistry::write()
{
    FXString pathname,tempname;

    // Settings have not changed
    if(!isModified()) return true;

    // We can not save if no application key given
    if(!applicationkey.empty())
    {
        // Changes written only in the per-user registry
        pathname=FXSystem::getHomeDirectory()+PATHSEPSTRING LOCALPATH;

        // If this directory does not exist, make it
        if(!FXStat::exists(pathname))
        {
            if(!FXDir::create(pathname))
                return false;
        }
        else
        {
            if(!FXStat::isDirectory(pathname))
                return false;
        }

        // Add vendor subdirectory
        if(!vendorkey.empty())
        {
            pathname.append(PATHSEPSTRING+vendorkey);
            if(!FXStat::exists(pathname))
            {
                if(!FXDir::create(pathname))
                    return false;
            }
            else
            {
                if(!FXStat::isDirectory(pathname))
                    return false;
            }
        }

        // Add application key
        pathname.append(PATHSEPSTRING+applicationkey);

        // Construct temp name
        tempname.format("%s_%d",pathname.text(),fxgetpid());

        // Unparse settings into temp file first
        if(unparseFile(tempname))
        {

            // Rename ATOMICALLY to proper name
            if(!FXFile::rename(tempname,pathname))
                return false;

            setModified(false);
            return true;
        }
    }
    return false;
}



// The function below is taken from the FXIconList class
// and hacked to right justify the second column of the file list (file size)
// Also hacked to display a gray bar one line over two
// It replaces the normal function...

#define SIDE_SPACING             4    // Left or right spacing between items
#define DETAIL_TEXT_SPACING      2    // Spacing between text and icon in detail icon mode

extern FXColor highlightcolor;

void FXIconItem::drawDetails(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint,FXint h) const
{
    register FXHeader *header=list->getHeader();
    register FXFont *font=list->getFont();
    register FXint iw=0,ih=0,tw=0,th=0,yt,beg,end,hi,drw,space,used,dw,xx;
		
    if(header->getNumItems()==0)
        return;
	
	// !!!! Hack to display a grey bar in the Filelist, one line over two
	static FXbool highlight=FALSE;

	// Reset highlight variable at the beginning of the list
	if (list->getItemAt(x,y)==0)
		highlight=FALSE;

	// Draw gray bar
	if (highlight)
	{
		dc.setForeground(highlightcolor);
        dc.fillRectangle(x,y,header->getTotalSize(),h);
	}
	highlight = !highlight;
	// !!!! End of hack

	if(isSelected())
    {
		dc.setForeground(list->getSelBackColor());
        dc.fillRectangle(x,y,header->getTotalSize(),h);
    }
    if(hasFocus())
        dc.drawFocusRectangle(x+1,y+1,header->getTotalSize()-2,h-2);
    xx=x+SIDE_SPACING/2;
    if(miniIcon)
    {
        iw=miniIcon->getWidth();
        ih=miniIcon->getHeight();
        dc.setClipRectangle(x,y,header->getItemSize(0),h);
        dc.drawIcon(miniIcon,xx,y+(h-ih)/2);
        dc.clearClipRectangle();
        xx+=iw+DETAIL_TEXT_SPACING;
    }
    if(!label.empty())
    {
        th=font->getFontHeight();
        dw=font->getTextWidth("...",3);
        yt=y+(h-th-4)/2;
        if(!isEnabled())
            dc.setForeground(makeShadowColor(list->getBackColor()));
        else if(isSelected())
            dc.setForeground(list->getSelTextColor());
        else
            dc.setForeground(list->getTextColor());
        used=iw+DETAIL_TEXT_SPACING+SIDE_SPACING/2;
 
		for(hi=beg=0; beg<label.length() && hi<header->getNumItems(); hi++,beg=end+1)
        {
            space=header->getItemSize(hi)-used;
            for(end=beg; end<label.length() && label[end]!='\t'; end++)
                ;
            if(end>beg)
            {
                drw=end-beg;
                tw=font->getTextWidth(&label[beg],drw);
                if(tw>space-4)
                {
                    while((tw=font->getTextWidth(&label[beg],drw))+dw>space-4 && drw>1)
                        drw--;
                    dc.setClipRectangle(xx,y,space,h);
                    dc.drawText(xx+2,yt+font->getFontAscent()+2,&label[beg],drw);
                    dc.drawText(xx+tw+2,yt+font->getFontAscent()+2,"...",3);
                    dc.clearClipRectangle();
                }
                else
                {
					// !!!! Hack to right justify the second column (file size)
                    if (hi==1)
                        dc.drawText(xx+space-tw-20,yt+font->getFontAscent()+2,&label[beg],drw);
                    else
                        dc.drawText(xx+2,yt+font->getFontAscent()+2,&label[beg],drw);
                    // !!!! End of hack
               }
            }
            xx+=space;
            used=0;
        }
    }
}


// The function below is taken from the FXIconList class
// and hacked to allow single click navigation in the FileList
// It replaces the normal function...

#define SELECT_MASK   (ICONLIST_EXTENDEDSELECT|ICONLIST_SINGLESELECT|ICONLIST_BROWSESELECT|ICONLIST_MULTIPLESELECT)

long FXIconList::onKeyPress(FXObject*,FXSelector,void* ptr)
{
    FXEvent* event=(FXEvent*)ptr;
    FXint index=current;
    flags&=~FLAG_TIP;
    if(!isEnabled())
		return 0;
    if(target && target->tryHandle(this,FXSEL(SEL_KEYPRESS,message),ptr))
		return 1;
    switch(event->code)
    {
    case KEY_Control_L:
    case KEY_Control_R:
    case KEY_Shift_L:
    case KEY_Shift_R:
    case KEY_Alt_L:
    case KEY_Alt_R:
        if(flags&FLAG_DODRAG)
            handle(this,FXSEL(SEL_DRAGGED,0),ptr);
        return 1;
    case KEY_Page_Up:
    case KEY_KP_Page_Up:
        lookup=FXString::null;
        setPosition(pos_x,pos_y+verticalScrollBar()->getPage());
        return 1;
    case KEY_Page_Down:
    case KEY_KP_Page_Down:
        lookup=FXString::null;
        setPosition(pos_x,pos_y-verticalScrollBar()->getPage());
        return 1;
    case KEY_Right:
    case KEY_KP_Right:
        if(!(options&(ICONLIST_BIG_ICONS|ICONLIST_MINI_ICONS)))
        {
            setPosition(pos_x-10,pos_y);
            return 1;
        }
        if(options&ICONLIST_COLUMNS)
			index+=1;
        else
			index+=nrows;
        goto hop;
    case KEY_Left:
    case KEY_KP_Left:
        if(!(options&(ICONLIST_BIG_ICONS|ICONLIST_MINI_ICONS)))
        {
            setPosition(pos_x+10,pos_y);
            return 1;
        }
        if(options&ICONLIST_COLUMNS)
			index-=1;
        else
			index-=nrows;
        goto hop;
    case KEY_Up:
    case KEY_KP_Up:
        if(options&ICONLIST_COLUMNS)
			index-=ncols;
        else
			index-=1;
        goto hop;
    case KEY_Down:
    case KEY_KP_Down:
        if(options&ICONLIST_COLUMNS)
			index+=ncols;
        else
			index+=1;
        goto hop;
    case KEY_Home:
    case KEY_KP_Home:
        index=0;
        goto hop;
    case KEY_End:
    case KEY_KP_End:
        index=items.no()-1;
hop:
        lookup=FXString::null;
        if(0<=index && index<items.no())
        {
            setCurrentItem(index,TRUE);
            makeItemVisible(index);
            if(items[index]->isEnabled())
            {
                if((options&SELECT_MASK)==ICONLIST_EXTENDEDSELECT)
                {
                    if(event->state&SHIFTMASK)
                    {
                        if(0<=anchor)
                        {
                            selectItem(anchor,TRUE);
                            extendSelection(index,TRUE);
                        }
                        else
                            selectItem(index,TRUE);
                    }
                    else if(!(event->state&CONTROLMASK))
                    {
                        killSelection(TRUE);
                        selectItem(index,TRUE);
                        setAnchorItem(index);
                    }
                }
            }
        }
		
		// !!!! Hack to allow single click navigation in the FileList 
        //handle(this,FXSEL(SEL_CLICKED,0),(void*)(FXival)current);
        // !!!! End of hack
		
		if(0<=current && items[current]->isEnabled())
            handle(this,FXSEL(SEL_COMMAND,0),(void*)(FXival)current);
        return 1;
    case KEY_space:
    case KEY_KP_Space:
        lookup=FXString::null;
        if(0<=current && items[current]->isEnabled())
        {
            switch(options&SELECT_MASK)
            {
            case ICONLIST_EXTENDEDSELECT:
                if(event->state&SHIFTMASK)
                {
                    if(0<=anchor)
                    {
                        selectItem(anchor,TRUE);
                        extendSelection(current,TRUE);
                    }
                    else
                        selectItem(current,TRUE);
                }
                else if(event->state&CONTROLMASK)
                    toggleItem(current,TRUE);
                else
                {
                    killSelection(TRUE);
                    selectItem(current,TRUE);
                }
                break;
            case ICONLIST_MULTIPLESELECT:
            case ICONLIST_SINGLESELECT:
                toggleItem(current,TRUE);
                break;
            }
            setAnchorItem(current);
        }
        handle(this,FXSEL(SEL_CLICKED,0),(void*)(FXival)current);
        if(0<=current && items[current]->isEnabled())
            handle(this,FXSEL(SEL_COMMAND,0),(void*)(FXival)current);
        return 1;
    case KEY_Return:
    case KEY_KP_Enter:
        lookup=FXString::null;
        handle(this,FXSEL(SEL_DOUBLECLICKED,0),(void*)(FXival)current);
        if(0<=current && items[current]->isEnabled())
            handle(this,FXSEL(SEL_COMMAND,0),(void*)(FXival)current);
        return 1;
    default:
        if((FXuchar)event->text[0]<' ')
			return 0;
        if(event->state&(CONTROLMASK|ALTMASK))
			return 0;
        if(!Ascii::isPrint(event->text[0]))
			return 0;
        lookup.append(event->text);
        getApp()->addTimeout(this,ID_LOOKUPTIMER,getApp()->getTypingSpeed());
        index=findItem(lookup,current,SEARCH_FORWARD|SEARCH_WRAP|SEARCH_PREFIX);
        if(0<=index)
        {
            setCurrentItem(index,TRUE);
            makeItemVisible(index);
            if(items[index]->isEnabled())
            {
                if((options&SELECT_MASK)==ICONLIST_EXTENDEDSELECT)
                {
                    killSelection(TRUE);
                    selectItem(index,TRUE);
                }
                setAnchorItem(index);
            }
        }
        handle(this,FXSEL(SEL_CLICKED,0),(void*)(FXival)current);
        if(0<=current && items[current]->isEnabled())
            handle(this,FXSEL(SEL_COMMAND,0),(void*)(FXival)current);
        return 1;
    }
    return 0;
}


// Move content
void FXIconList::moveContents(FXint x,FXint y)
{
    FXint dx=x-pos_x;
    FXint dy=y-pos_y;
    FXint top=0;
    pos_x=x;
    pos_y=y;
    if(!(options&(ICONLIST_MINI_ICONS|ICONLIST_BIG_ICONS)))
    {
        top=header->getDefaultHeight();
        header->setPosition(x);
    }
    scroll(0,top,viewport_w,viewport_h,dx,dy);
	
	// !!!! Hack to add a refresh when scrolling with one grey line over two 
	recalc();
	// !!!! End of hack
}



// The two functions below are taken from the FXPopup class
// and hacked to allow navigating using the keyboard on popup menus
// They replace the normal functions...

// !!!! Global variable control keyboard scrolling on right click popup menus !!!!
extern FXbool allowPopupScroll;

void FXPopup::setFocus()
{
	FXShell::setFocus();
    
	// !!!! Hack to allow keyboard scroll on popup dialogs !!!!
	if (allowPopupScroll)
		grabKeyboard();
}

void FXPopup::killFocus()
{
    FXShell::killFocus();

	// !!!! Hack to allow keyboard scroll on popup dialogs !!!!
	if (allowPopupScroll)
	{
		if(prevActive)
			prevActive->setFocus();
		else
			ungrabKeyboard();
	}

}



// Status line construct and init (translation hack)
FXStatusLine::FXStatusLine(FXComposite* p,FXObject* tgt,FXSelector sel):
  FXFrame(p,FRAME_SUNKEN|LAYOUT_LEFT|LAYOUT_FILL_Y|LAYOUT_FILL_X,0,0,0,0, 4,4,2,2)
{
	flags|=FLAG_SHOWN;
	status=normal=_("Ready.");
	font=getApp()->getNormalFont();
	textColor=getApp()->getForeColor();
	textHighlightColor=getApp()->getForeColor();
	target=tgt;
	message=sel;
}



// Taken from the FXReplaceDialog class (translation hack)

// Padding for buttons
#define HORZ_PAD      12
#define VERT_PAD      2
#define SEARCH_MASK   (SEARCH_EXACT|SEARCH_IGNORECASE|SEARCH_REGEX)

// File Open Dialog
FXReplaceDialog::FXReplaceDialog(FXWindow* owner,const FXString& caption,FXIcon* ic,FXuint opts,FXint x,FXint y,FXint w,FXint h):
        FXDialogBox(owner,caption,opts|DECOR_TITLE|DECOR_BORDER|DECOR_RESIZE,x,y,w,h,10,10,10,10, 10,10)
{
    FXHorizontalFrame* buttons=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH|PACK_UNIFORM_HEIGHT,0,0,0,0,0,0,0,0);
    accept=new FXButton(buttons,_("&Replace"),NULL,this,ID_ACCEPT,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_Y|LAYOUT_RIGHT,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    every=new FXButton(buttons,_("Re&place All"),NULL,this,ID_ALL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_RIGHT,0,0,0,0,6,6,VERT_PAD,VERT_PAD);
    cancel=new FXButton(buttons,_("&Cancel"),NULL,this,ID_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_Y|LAYOUT_RIGHT,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    FXHorizontalFrame* pair=new FXHorizontalFrame(buttons,LAYOUT_FILL_Y|LAYOUT_RIGHT,0,0,0,0, 0,0,0,0);
    FXArrowButton* searchlast=new FXArrowButton(pair,this,ID_PREV,ARROW_LEFT|FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_Y,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    FXArrowButton* searchnext=new FXArrowButton(pair,this,ID_NEXT,ARROW_RIGHT|FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_Y,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXHorizontalSeparator(this,SEPARATOR_GROOVE|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X);
    FXHorizontalFrame* toppart=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0, 10,10);
    new FXLabel(toppart,FXString::null,ic,ICON_BEFORE_TEXT|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y|LAYOUT_FILL_Y|LAYOUT_FILL_X);
    FXVerticalFrame* entry=new FXVerticalFrame(toppart,LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0);
    searchlabel=new FXLabel(entry,_("Search for:"),NULL,JUSTIFY_LEFT|ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X);
    searchbox=new FXHorizontalFrame(entry,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0, 0,0);
    searchtext=new FXTextField(searchbox,26,this,ID_SEARCH_TEXT,TEXTFIELD_ENTER_ONLY|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 4,4,4,4);
    FXVerticalFrame* searcharrows=new FXVerticalFrame(searchbox,LAYOUT_RIGHT|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0, 0,0);
    FXArrowButton* ar1=new FXArrowButton(searcharrows,this,ID_SEARCH_UP,FRAME_RAISED|FRAME_THICK|ARROW_UP|ARROW_REPEAT|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH, 0,0,16,0, 1,1,1,1);
    FXArrowButton* ar2=new FXArrowButton(searcharrows,this,ID_SEARCH_DN,FRAME_RAISED|FRAME_THICK|ARROW_DOWN|ARROW_REPEAT|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH, 0,0,16,0, 1,1,1,1);
    ar1->setArrowSize(3);
    ar2->setArrowSize(3);
    replacelabel=new FXLabel(entry,_("Replace with:"),NULL,LAYOUT_LEFT);
    replacebox=new FXHorizontalFrame(entry,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0, 0,0);
    replacetext=new FXTextField(replacebox,26,this,ID_REPLACE_TEXT,TEXTFIELD_ENTER_ONLY|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 4,4,4,4);
    FXVerticalFrame* replacearrows=new FXVerticalFrame(replacebox,LAYOUT_RIGHT|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0, 0,0);
    FXArrowButton* ar3=new FXArrowButton(replacearrows,this,ID_REPLACE_UP,FRAME_RAISED|FRAME_THICK|ARROW_UP|ARROW_REPEAT|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH, 0,0,16,0, 1,1,1,1);
    FXArrowButton* ar4=new FXArrowButton(replacearrows,this,ID_REPLACE_DN,FRAME_RAISED|FRAME_THICK|ARROW_DOWN|ARROW_REPEAT|LAYOUT_FILL_Y|LAYOUT_FIX_WIDTH, 0,0,16,0, 1,1,1,1);
    ar3->setArrowSize(3);
    ar4->setArrowSize(3);
    FXHorizontalFrame* options1=new FXHorizontalFrame(entry,LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
    new FXRadioButton(options1,_("Ex&act"),this,ID_MODE+SEARCH_EXACT,ICON_BEFORE_TEXT|LAYOUT_CENTER_X);
    new FXRadioButton(options1,_("&Ignore Case"),this,ID_MODE+SEARCH_IGNORECASE,ICON_BEFORE_TEXT|LAYOUT_CENTER_X);
    new FXRadioButton(options1,_("E&xpression"),this,ID_MODE+SEARCH_REGEX,ICON_BEFORE_TEXT|LAYOUT_CENTER_X);
    new FXCheckButton(options1,_("&Backward"),this,ID_DIR,ICON_BEFORE_TEXT|LAYOUT_CENTER_X);
    searchlast->setTipText("Ctrl-B");
    searchnext->setTipText("Ctrl-F");
    searchlast->addHotKey(MKUINT(KEY_b,CONTROLMASK));
    searchnext->addHotKey(MKUINT(KEY_f,CONTROLMASK));
    searchmode=SEARCH_EXACT|SEARCH_FORWARD;
    current=0;
}

// Taken from the FXSearchDialog class (translation hack)
FXSearchDialog::FXSearchDialog(FXWindow* owner,const FXString& caption,FXIcon* ic,FXuint opts,FXint x,FXint y,FXint w,FXint h):
        FXReplaceDialog(owner,caption,ic,opts,x,y,w,h)
{
    accept->setText(_("&Search"));
    every->hide();
    replacelabel->hide();
    replacebox->hide();
}

// Taken from the FXInputDialog class (translation hack)
void FXInputDialog::initialize(const FXString& label,FXIcon* icon)
{
	FXuint textopts=TEXTFIELD_ENTER_ONLY|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X;
	FXHorizontalFrame* buttons=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH,0,0,0,0,0,0,0,0);
	new FXButton(buttons,_("&OK"),NULL,this,ID_ACCEPT,BUTTON_INITIAL|BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_RIGHT,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
	new FXButton(buttons,_("&Cancel"),NULL,this,ID_CANCEL,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_RIGHT,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
	new FXHorizontalSeparator(this,SEPARATOR_GROOVE|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X);
	FXHorizontalFrame* toppart=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0, 10,10);
	new FXLabel(toppart,FXString::null,icon,ICON_BEFORE_TEXT|JUSTIFY_CENTER_X|JUSTIFY_CENTER_Y|LAYOUT_FILL_Y|LAYOUT_FILL_X);
	FXVerticalFrame* entry=new FXVerticalFrame(toppart,LAYOUT_FILL_X|LAYOUT_CENTER_Y,0,0,0,0, 0,0,0,0);
	new FXLabel(entry,label,NULL,JUSTIFY_LEFT|ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X);
	if(options&INPUTDIALOG_PASSWORD)
		textopts|=TEXTFIELD_PASSWD;
	if(options&INPUTDIALOG_INTEGER)
		textopts|=TEXTFIELD_INTEGER|JUSTIFY_RIGHT;
	if(options&INPUTDIALOG_REAL)
		textopts|=TEXTFIELD_REAL|JUSTIFY_RIGHT;
	input=new FXTextField(entry,20,this,ID_ACCEPT,textopts,0,0,0,0, 8,8,4,4);
	limlo=1.0;
	limhi=0.0;
  }


// Taken from the FXText class (translation hack)
long FXText::onCmdGotoLine(FXObject*,FXSelector,void*)
{
    FXint row=cursorrow+1;
    if(FXInputDialog::getInteger(row,this,_("Goto Line"),_("&Goto line number:"),gotobigicon,1,2147483647))
    {
        update();
        setCursorRow(row-1,TRUE);
        makePositionVisible(cursorpos);
	}
    return 1;
}


// Taken from the FXText class (translation hack)
long FXText::onCmdSearch(FXObject*,FXSelector,void*)
{
    FXSearchDialog searchdialog(this,_("Search"),searchicon);
    FXint beg[10];
    FXint end[10];
    FXint pos;
    FXuint code;
    do
    {
        code=searchdialog.execute();
        if(code==FXSearchDialog::DONE) return 1;
        searchstring=searchdialog.getSearchText();
        searchflags=searchdialog.getSearchMode();
		pos=isPosSelected(cursorpos) ? (searchflags&SEARCH_BACKWARD) ? selstartpos-1 : selendpos : cursorpos;
        if(findText(searchstring,beg,end,pos,searchflags|SEARCH_WRAP,10))
        {
            setAnchorPos(beg[0]);
            extendSelection(end[0],SELECT_CHARS,TRUE);
            setCursorPos(end[0],TRUE);
            makePositionVisible(beg[0]);
            makePositionVisible(end[0]);
        }
    }
    while(code==FXSearchDialog::SEARCH_NEXT);
    return 1;
}


// Taken from the FXText class (translation hack)
long FXText::onCmdReplace(FXObject*,FXSelector,void*)
{
    FXReplaceDialog replacedialog(this,_("Replace"),replaceicon);
    FXint beg[10],end[10],fm,to,len,pos;
    FXuint searchflags,code;
    FXString searchstring;
    FXString replacestring;
    FXString replacevalue;
    do
    {
        code=replacedialog.execute();
        if(code==FXReplaceDialog::DONE) return 1;
        searchflags=replacedialog.getSearchMode();
        searchstring=replacedialog.getSearchText();
        replacestring=replacedialog.getReplaceText();
        replacevalue=FXString::null;
        fm=-1;
        to=-1;
        if(code==FXReplaceDialog::REPLACE_ALL)
        {
            searchflags&=~SEARCH_BACKWARD;
            pos=0;
            while(findText(searchstring,beg,end,pos,searchflags,10))
            {
                if(0<=fm) replacevalue.append(&buffer[pos],beg[0]-pos);
                replacevalue.append(FXRex::substitute(buffer,length,beg,end,replacestring,10));
                if(fm<0) fm=beg[0];
                to=end[0];
                pos=end[0];
                if(beg[0]==end[0]) pos++;
            }
        }
        else
        {
			pos=isPosSelected(cursorpos) ? (searchflags&SEARCH_BACKWARD) ? selstartpos-1 : selendpos : cursorpos;
            if(findText(searchstring,beg,end,pos,searchflags|SEARCH_WRAP,10))
            {
                replacevalue=FXRex::substitute(buffer,length,beg,end,replacestring,10);
                fm=beg[0];
                to=end[0];
            }
        }
        if(0<=fm)
        {
            len=replacevalue.length();
            replaceText(fm,to-fm,replacevalue.text(),len,TRUE);
            setCursorPos(fm+len,TRUE);
            makePositionVisible(getCursorPos());
            modified=TRUE;
        }
    }
    while(code==FXReplaceDialog::REPLACE_NEXT);
    return 1;
}

