#ifndef XFILEQUERY_H
#define XFILEQUERY_H

class XFileQuery : public FXMainWindow
{
    FXDECLARE(XFileQuery)
protected:
    FXMenuBar			*menubar;			// Menu bar
    FXMenuPane			*filemenu;			// File menu
    FXMenuPane			*helpmenu;			// Help menu
    FXMenuPane			*prefsmenu;			// Preferences menu
    FXHorizontalFrame	*contents;			// Sunken border for text widget
    FXToolBar			*toolbar;			// Toolbar
    FXString 			filename;			// Current package name
    FXTreeList 			*list;				// File list
    FXText 				*description;		// Package description
    FXbool 				desc_clean;			// Clean description flag
    FXbool 				list_clean;			// Clean list flag
    XFileQuery()
    {}
public:
    enum{
        ID_DESCRIPTION=FXMainWindow::ID_LAST,
        ID_FILELIST,
        ID_UNINSTALL,
        ID_INSTALL,
		ID_ABOUT,
		ID_OPEN,
        ID_QUIT,
        ID_LAST
    };
    void start(FXString startpkg);
    void create();
    XFileQuery(FXApp *a);
	~XFileQuery();
    long onCmdUninstall(FXObject*,FXSelector,void*);
    long onCmdInstall(FXObject*,FXSelector,void*);
	long onCmdAbout(FXObject*,FXSelector,void*);
	long onCmdOpen(FXObject*,FXSelector,void*);
    long onUpdDescription(FXObject*,FXSelector,void*);
    long onUpdFileList(FXObject*,FXSelector,void*);
	void saveConfig();
    long onCmdQuit(FXObject*,FXSelector,void*);
};

#endif
