# TRY_LINK_SDL_MIXER
# Checks for the -lSDL_mixer library.
# Assumes that the AM_PATH_GENGAMENG macro has already succeeded.
#
AC_DEFUN([TRY_LINK_SDL_MIXER],
[
	# The gengameng check checks for the SDL library.
	# Check also for the SDL_mixer library
	# (http://www.libsdl.org/projects/SDL_mixer/):
	#
	AC_MSG_CHECKING([for SDL_mixer])
	old_CXXFLAGS="$CXXFLAGS"
	old_LIBS="$LIBS"
	CXXFLAGS="$GENGAMENG_FLAGS"
	LIBS="$GENGAMENG_LIBS -lSDL_mixer"
	AC_TRY_LINK(
		[
			#include <SDL/SDL_mixer.h>
		],
		[
			(void) Mix_OpenAudio(11025, AUDIO_U8, 1, 512);
			return 0;
		],
		[
			AC_MSG_RESULT([found])
		],
		[
			AC_MSG_ERROR([SDL_mixer not found

	SDL_mixer 1.2.4 or later is needed.
	See http://www.libsdl.org/projects/SDL_mixer/
	])
		]
	)
	CXXFLAGS="$old_CXXFLAGS"
	LIBS="$old_LIBS"
])
